/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.impl.wsdl.teststeps.ManualTestStep;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class ManualTestStepDesktopPanel
extends ModelItemDesktopPanel<ManualTestStep> {
    private JSplitPane split;
    private JUndoableTextField nameField;
    private JUndoableTextArea descriptionField;
    private JUndoableTextArea expectedResultField;

    public ManualTestStepDesktopPanel(ManualTestStep modelItem) {
        super(modelItem);
        this.buildUI();
    }

    private void buildUI() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("TestStep Name"));
        builder.addRelatedGap();
        this.nameField = new JUndoableTextField(((ManualTestStep)this.getModelItem()).getName());
        this.nameField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                ((ManualTestStep)ManualTestStepDesktopPanel.this.getModelItem()).setName(ManualTestStepDesktopPanel.this.nameField.getText());
            }
        });
        this.nameField.setPreferredSize(new Dimension(200, 20));
        builder.addFixed((JComponent)this.nameField);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)builder.getPanel(), "North");
        this.split = UISupport.createVerticalSplit(this.createDescriptionField(), this.createExpectedResultField());
        this.add((Component)this.split, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManualTestStepDesktopPanel.this.split.setDividerLocation(200);
            }
        });
    }

    protected JUndoableTextField getNameField() {
        return this.nameField;
    }

    protected JUndoableTextArea getDescriptionField() {
        return this.descriptionField;
    }

    protected JUndoableTextArea getExpectedResultField() {
        return this.expectedResultField;
    }

    private JPanel createDescriptionField() {
        JPanel panel = UISupport.createEmptyPanel(3, 3, 3, 3);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("<html><b>Description - Describe what actions to perform</b></html>"));
        panel.add((Component)builder.getPanel(), "North");
        this.descriptionField = new JUndoableTextArea(((ManualTestStep)this.getModelItem()).getDescription());
        this.descriptionField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                ((ManualTestStep)ManualTestStepDesktopPanel.this.getModelItem()).setDescription(ManualTestStepDesktopPanel.this.descriptionField.getText());
            }
        });
        panel.add(new JScrollPane(this.descriptionField));
        return panel;
    }

    private JPanel createExpectedResultField() {
        JPanel panel = UISupport.createEmptyPanel(3, 3, 3, 3);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("<html><b>Expected Result - Describe the expected outcome</b></html>"));
        panel.add((Component)builder.getPanel(), "North");
        this.expectedResultField = new JUndoableTextArea(((ManualTestStep)this.getModelItem()).getExpectedResult());
        this.expectedResultField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                ((ManualTestStep)ManualTestStepDesktopPanel.this.getModelItem()).setExpectedResult(ManualTestStepDesktopPanel.this.expectedResultField.getText());
            }
        });
        panel.add(new JScrollPane(this.expectedResultField));
        return panel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String newValue = String.valueOf(evt.getNewValue());
        if (evt.getPropertyName().equals(ManualTestStep.NAME_PROPERTY)) {
            if (!newValue.equals(this.nameField.getText())) {
                this.nameField.setText(newValue);
            }
        } else if (evt.getPropertyName().equals(ManualTestStep.DESCRIPTION_PROPERTY)) {
            if (!newValue.equals(this.descriptionField.getText())) {
                this.descriptionField.setText(newValue);
            }
        } else if (evt.getPropertyName().equals("expectedResult") && !newValue.equals(this.expectedResultField.getText())) {
            this.expectedResultField.setText(newValue);
        }
    }
}

