/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.http.HttpRequest;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.ListDataChangeListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class HttpTestRequestDesktopPanel
extends AbstractHttpXmlRequestDesktopPanel<HttpTestRequestStepInterface, HttpTestRequestInterface<?>> {
    private JLogList logArea;
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    private JButton addAssertionButton;
    protected boolean updatingRequest;
    private AssertionsPanel assertionsPanel;
    private JInspectorPanel inspectorPanel;
    private JComponentInspector<?> assertionInspector;
    private JComponentInspector<?> logInspector;
    private InternalAssertionsListener assertionsListener = new InternalAssertionsListener();
    private long startTime;
    private boolean updating;
    private JUndoableTextField pathTextField;
    private JCheckBox downloadResources;
    private JComboBox methodCombo;

    public HttpTestRequestDesktopPanel(HttpTestRequestStepInterface testStep) {
        super(testStep, testStep.getTestRequest());
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(testStep.getTestCase()));
        testStep.getTestRequest().addAssertionsListener(this.assertionsListener);
        this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((HttpTestRequestInterface)this.getRequest()).getEndpoint()));
    }

    protected JComponent buildLogPanel() {
        this.logArea = new JLogList("Request Log");
        this.logArea.getLogList().getModel().addListDataListener(new ListDataChangeListener(){

            @Override
            public void dataChanged(ListModel model) {
                HttpTestRequestDesktopPanel.this.logInspector.setTitle("Request Log (" + model.getSize() + ")");
            }
        });
        return this.logArea;
    }

    protected AssertionsPanel buildAssertionsPanel() {
        return new AssertionsPanel((Assertable)this.getRequest()){

            @Override
            protected void selectError(AssertionError error) {
                ModelItemXmlEditor<?, ?> editor = HttpTestRequestDesktopPanel.this.getResponseEditor();
                editor.requestFocus();
            }
        };
    }

    @Override
    public void setContent(JComponent content) {
        this.inspectorPanel.setContentComponent(content);
    }

    @Override
    public void removeContent(JComponent content) {
        this.inspectorPanel.setContentComponent(null);
    }

    @Override
    protected String getHelpUrl() {
        return "http://www.soapui.org/Functional-Testing/testrequest-editor.html";
    }

    @Override
    protected JComponent buildContent() {
        JComponent component = super.buildContent();
        this.inspectorPanel = JInspectorPanelFactory.build(component);
        this.assertionsPanel = this.buildAssertionsPanel();
        this.assertionInspector = new JComponentInspector<AssertionsPanel>(this.assertionsPanel, "Assertions (" + ((HttpTestRequestStepInterface)this.getModelItem()).getAssertionCount() + ")", "Assertions for this Test Request", true);
        this.inspectorPanel.addInspector(this.assertionInspector);
        this.logInspector = new JComponentInspector<JComponent>(this.buildLogPanel(), "Request Log (0)", "Log of requests", true);
        this.inspectorPanel.addInspector(this.logInspector);
        this.inspectorPanel.setDefaultDividerLocation(0.6f);
        this.inspectorPanel.setCurrentInspector("Assertions");
        this.updateStatusIcon();
        this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((HttpTestRequestInterface)this.getRequest()).getEndpoint()));
        return this.inspectorPanel.getComponent();
    }

    @Override
    protected JComponent buildEndpointComponent() {
        return null;
    }

    private void updateStatusIcon() {
        Assertable.AssertionStatus status = ((HttpTestRequestStepInterface)this.getModelItem()).getTestRequest().getAssertionStatus();
        switch (status) {
            case FAILED: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                this.inspectorPanel.activate(this.assertionInspector);
                break;
            }
            case UNKNOWN: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/unknown_assertion.gif"));
                break;
            }
            case VALID: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                this.inspectorPanel.deactivate();
            }
        }
    }

    protected void addMethodCombo(JXToolBar toolbar) {
        this.methodCombo = new JComboBox<RestRequestInterface.HttpMethod>(RestRequestInterface.HttpMethod.getMethods());
        this.methodCombo.setSelectedItem((Object)((HttpTestRequestInterface)this.getRequest()).getMethod());
        this.methodCombo.setToolTipText("Set desired HTTP method");
        this.methodCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HttpTestRequestDesktopPanel.this.updatingRequest = true;
                ((HttpTestRequestInterface)HttpTestRequestDesktopPanel.this.getRequest()).setMethod((RestRequestInterface.HttpMethod)((Object)HttpTestRequestDesktopPanel.this.methodCombo.getSelectedItem()));
                HttpTestRequestDesktopPanel.this.updatingRequest = false;
            }
        });
        toolbar.addLabeledFixed("Method", this.methodCombo);
        toolbar.addSeparator();
    }

    protected void addToolbarComponents(JXToolBar toolbar) {
        toolbar.addSeparator();
        this.addMethodCombo(toolbar);
        this.pathTextField = new JUndoableTextField();
        this.pathTextField.setPreferredSize(new Dimension(300, 20));
        this.pathTextField.setText(((HttpTestRequestInterface)this.getRequest()).getEndpoint());
        this.pathTextField.setToolTipText(this.pathTextField.getText());
        this.pathTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                if (HttpTestRequestDesktopPanel.this.updating) {
                    return;
                }
                HttpTestRequestDesktopPanel.this.updating = true;
                String text = HttpTestRequestDesktopPanel.this.pathTextField.getText();
                ((HttpTestRequestInterface)HttpTestRequestDesktopPanel.this.getRequest()).setEndpoint(HttpUtils.completeUrlWithHttpIfProtocolIsNotHttpOrHttpsOrPropertyExpansion(text));
                if (!text.equals(((HttpTestRequestInterface)HttpTestRequestDesktopPanel.this.getRequest()).getEndpoint())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HttpTestRequestDesktopPanel.this.pathTextField.setText(((HttpTestRequestInterface)HttpTestRequestDesktopPanel.this.getRequest()).getEndpoint());
                        }
                    });
                }
                HttpTestRequestDesktopPanel.this.updating = false;
            }
        });
        this.pathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    HttpTestRequestDesktopPanel.this.onSubmit();
                }
            }
        });
        JPanel pathPanel = new JPanel(new BorderLayout(0, 0));
        pathPanel.add((Component)this.getLockIcon(), "West");
        pathPanel.add((Component)this.pathTextField, "Center");
        toolbar.addLabeledFixed("Request URL:", pathPanel);
        toolbar.addSeparator();
        this.addCheckBox(toolbar);
    }

    private void addCheckBox(JXToolBar toolbar) {
        this.downloadResources = new JCheckBox();
        try {
            this.downloadResources.setSelected(((HttpRequest)((HttpTestRequestStepInterface)this.getModelItem()).getHttpRequest()).getDownloadIncludedResources());
        }
        catch (Exception cce) {
            SoapUI.logError(cce);
        }
        this.downloadResources.setPreferredSize(new Dimension(17, 17));
        this.downloadResources.setToolTipText("Download all included resources as attachments!");
        this.downloadResources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (1001 == e.getID() && HttpTestRequestDesktopPanel.this.getModelItem() instanceof HttpTestRequestStep) {
                        ((HttpRequest)((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getHttpRequest()).setDownloadIncludedResources(((JCheckBox)e.getSource()).isSelected());
                    }
                }
                catch (Exception cce) {
                    SoapUI.logError(cce);
                }
            }
        });
        toolbar.addLabeledFixed("Download Resources", this.downloadResources);
        toolbar.addSeparator();
    }

    @Override
    protected JComponent buildToolbar() {
        this.addAssertionButton = HttpTestRequestDesktopPanel.createActionButton(new AddAssertionAction((Assertable)this.getRequest()), true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)super.buildToolbar(), "North");
        JXToolBar toolbar = UISupport.createToolbar();
        this.addToolbarComponents(toolbar);
        panel.add((Component)toolbar, "South");
        return panel;
    }

    @Override
    protected void insertButtons(JXToolBar toolbar) {
        toolbar.add(this.addAssertionButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            enabled = !SoapUI.getTestMonitor().hasRunningLoadTest(((HttpTestRequestStepInterface)this.getModelItem()).getTestCase()) && !SoapUI.getTestMonitor().hasRunningSecurityTest(((HttpTestRequestStepInterface)this.getModelItem()).getTestCase());
        }
        super.setEnabled(enabled);
        this.addAssertionButton.setEnabled(enabled);
        this.assertionsPanel.setEnabled(enabled);
        if (SoapUI.getTestMonitor().hasRunningLoadTest(((HttpTestRequestInterface)this.getRequest()).getTestCase()) || SoapUI.getTestMonitor().hasRunningSecurityTest(((HttpTestRequestStepInterface)this.getModelItem()).getTestCase())) {
            ((HttpTestRequestInterface)this.getRequest()).removeSubmitListener(this);
        } else {
            ((HttpTestRequestInterface)this.getRequest()).addSubmitListener(this);
        }
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        Analytics.trackAction((String)SoapUIActions.RUN_TEST_STEP.getActionName(), (String[])new String[]{"StepType", "HTTP"});
        return ((HttpTestRequestInterface)this.getRequest()).submit(new WsdlTestRunContext((TestStep)this.getModelItem()), true);
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        boolean result = super.beforeSubmit(submit, context);
        this.startTime = System.currentTimeMillis();
        return result;
    }

    @Override
    protected void logMessages(String message, String infoMessage) {
        super.logMessages(message, infoMessage);
        this.logArea.addLine(DateUtil.formatFull(new Date(this.startTime)) + " - " + message);
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        super.afterSubmit(submit, context);
        if (!this.isHasClosed()) {
            this.updateStatusIcon();
        }
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (super.onClose(canCancel)) {
            this.assertionsPanel.release();
            this.inspectorPanel.release();
            SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
            ((HttpTestRequestStepInterface)this.getModelItem()).getTestRequest().removeAssertionsListener(this.assertionsListener);
            return true;
        }
        return false;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        if (((HttpTestRequestInterface)this.getRequest()).getOperation() == null) {
            return modelItem == this.getRequest() || modelItem == this.getModelItem() || ModelSupport.getModelItemProject(this.getRequest()) == modelItem || modelItem == ((HttpTestRequestStepInterface)this.getModelItem()).getTestCase() || modelItem == ((HttpTestRequestStepInterface)this.getModelItem()).getTestCase().getTestSuite();
        }
        return modelItem == this.getRequest() || modelItem == this.getModelItem() || modelItem == ((HttpTestRequestInterface)this.getRequest()).getOperation() || modelItem == ((HttpTestRequestInterface)this.getRequest()).getOperation().getInterface() || modelItem == ((HttpTestRequestInterface)this.getRequest()).getOperation().getInterface().getProject() || modelItem == ((HttpTestRequestStepInterface)this.getModelItem()).getTestCase() || modelItem == ((HttpTestRequestStepInterface)this.getModelItem()).getTestCase().getTestSuite();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(RestTestRequestInterface.STATUS_PROPERTY)) {
            this.updateStatusIcon();
        } else if (evt.getPropertyName().equals("path")) {
            this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((HttpTestRequestInterface)this.getRequest()).getEndpoint()));
        } else if (evt.getPropertyName().equals("endpoint")) {
            if (this.updating) {
                return;
            }
            this.updating = true;
            this.pathTextField.setText(String.valueOf(evt.getNewValue()));
            this.updating = false;
        }
        super.propertyChange(evt);
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        @Override
        public void loadTestFinished(LoadTestRunner runner) {
            HttpTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                HttpTestRequestDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void securityTestFinished(SecurityTestRunner runner) {
            HttpTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void securityTestStarted(SecurityTestRunner runner) {
            if (runner.getSecurityTest().getTestCase() == ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                HttpTestRequestDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void testCaseFinished(TestCaseRunner runner) {
            HttpTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void testCaseStarted(TestCaseRunner runner) {
            if (runner.getTestCase() == ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                HttpTestRequestDesktopPanel.this.setEnabled(false);
            }
        }
    }

    private final class InternalAssertionsListener
    implements AssertionsListener {
        private InternalAssertionsListener() {
        }

        @Override
        public void assertionAdded(TestAssertion assertion) {
            HttpTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionRemoved(TestAssertion assertion) {
            HttpTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionMoved(TestAssertion assertion, int ix, int offset) {
            HttpTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }
    }
}

