/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.impl.wsdl.panels.testcase.TestRunLog;
import com.eviware.soapui.impl.wsdl.testcase.TestCaseLogItem;
import com.eviware.soapui.impl.wsdl.testcase.TestCaseLogModel;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.components.JHyperlinkLabel;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class JTestRunLog
extends JPanel
implements TestRunLog {
    private TestCaseLogModel logListModel;
    private JList testLogList;
    private boolean errorsOnly = false;
    private final Settings settings;
    private Set<String> boldTexts = new HashSet<String>();
    private boolean follow = true;
    protected int selectedIndex;
    private XFormDialog optionsDialog;

    public JTestRunLog(Settings settings) {
        super(new BorderLayout());
        this.settings = settings;
        this.errorsOnly = settings.getBoolean(OptionsForm.class.getName() + "@errors_only");
        this.buildUI();
    }

    private void buildUI() {
        this.logListModel = new TestCaseLogModel();
        this.logListModel.setMaxSize((int)this.settings.getLong(OptionsForm.class.getName() + "@max_rows", 1000L));
        this.testLogList = new JList(this.logListModel);
        this.testLogList.setCellRenderer(new TestLogCellRenderer());
        this.testLogList.setPrototypeCellValue("Testing 123");
        this.testLogList.setFixedCellWidth(-1);
        this.testLogList.addMouseListener(new LogListMouseListener());
        JScrollPane scrollPane = new JScrollPane(this.testLogList);
        this.add((Component)scrollPane, "Center");
        this.add(this.buildToolbar(), "North");
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.addToolbarButtons(toolbar);
        return toolbar;
    }

    protected JList getTestLogList() {
        return this.testLogList;
    }

    public boolean isErrorsOnly() {
        return this.errorsOnly;
    }

    public boolean isFollow() {
        return this.follow;
    }

    protected void addToolbarButtons(JXToolBar toolbar) {
        toolbar.addFixed(UISupport.createToolbarButton(new ClearLogAction()));
        toolbar.addFixed(UISupport.createToolbarButton(new SetLogOptionsAction()));
        toolbar.addFixed(UISupport.createToolbarButton(new ExportLogAction()));
    }

    @Override
    public synchronized void clear() {
        this.logListModel.clear();
        this.boldTexts.clear();
    }

    @Override
    public synchronized void addText(String string) {
        this.logListModel.addText(string);
        if (this.follow) {
            this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
        }
    }

    @Override
    public synchronized void addTestStepResult(TestStepResult stepResult) {
        if (this.errorsOnly && stepResult.getStatus() != TestStepResult.TestStepStatus.FAILED) {
            return;
        }
        this.logListModel.addTestStepResult(stepResult);
        if (this.follow) {
            try {
                this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public TestCaseLogModel getLogListModel() {
        return this.logListModel;
    }

    public void setLogListModel(TestCaseLogModel logListModel) {
        this.logListModel = logListModel;
        this.testLogList.setModel(logListModel);
    }

    public void setStepIndex(int i) {
        this.logListModel.setStepIndex(i);
    }

    @Override
    public synchronized void addBoldText(String string) {
        this.boldTexts.add(string);
        this.addText(string);
    }

    @Override
    public void release() {
        if (this.optionsDialog != null) {
            this.optionsDialog.release();
            this.optionsDialog = null;
        }
    }

    @Override
    public void printLog(PrintWriter out) {
        for (int c = 0; c < this.logListModel.getSize(); ++c) {
            TestCaseLogItem logItem;
            String msg;
            Object value = this.logListModel.getElementAt(c);
            if (value instanceof String) {
                out.println(value.toString());
                continue;
            }
            if (!(value instanceof TestCaseLogItem) || !StringUtils.hasContent(msg = (logItem = (TestCaseLogItem)value).getMsg())) continue;
            out.println(msg);
        }
    }

    private class ExportLogAction
    extends AbstractAction {
        public ExportLogAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/export.gif"));
            this.putValue("ShortDescription", "Exports this log to a file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = UISupport.getFileDialogs().saveAs(this, "Save Log");
            if (file != null) {
                try {
                    PrintWriter out = new PrintWriter(file);
                    JTestRunLog.this.printLog(out);
                    out.close();
                }
                catch (FileNotFoundException e1) {
                    UISupport.showErrorMessage(e1);
                }
            }
        }
    }

    private class ClearLogAction
    extends AbstractAction {
        public ClearLogAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/clear_loadtest.gif"));
            this.putValue("ShortDescription", "Clears the log");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTestRunLog.this.logListModel.clear();
        }
    }

    @AForm(name="Log Options", description="Set options for the run log below")
    private static interface OptionsForm {
        @AField(name="Max Rows", description="Sets the maximum number of rows to keep in the log", type=AField.AFieldType.INT)
        public static final String MAXROWS = "Max Rows";
        @AField(name="Errors Only", description="Logs only TestStep errors in the log", type=AField.AFieldType.BOOLEAN)
        public static final String ERRORSONLY = "Errors Only";
        @AField(name="Follow", description="Follow log content", type=AField.AFieldType.BOOLEAN)
        public static final String FOLLOW = "Follow";
    }

    private class SetLogOptionsAction
    extends AbstractAction {
        public SetLogOptionsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
            this.putValue("ShortDescription", "Sets TestCase Log Options");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JTestRunLog.this.optionsDialog == null) {
                JTestRunLog.this.optionsDialog = ADialogBuilder.buildDialog(OptionsForm.class);
            }
            JTestRunLog.this.optionsDialog.setIntValue("Max Rows", (int)JTestRunLog.this.settings.getLong(OptionsForm.class.getName() + "@max_rows", 1000L));
            JTestRunLog.this.optionsDialog.setBooleanValue("Errors Only", JTestRunLog.this.settings.getBoolean(OptionsForm.class.getName() + "@errors_only"));
            JTestRunLog.this.optionsDialog.setBooleanValue("Follow", JTestRunLog.this.follow);
            if (JTestRunLog.this.optionsDialog.show()) {
                int maxRows = JTestRunLog.this.optionsDialog.getIntValue("Max Rows", 1000);
                JTestRunLog.this.logListModel.setMaxSize(maxRows);
                JTestRunLog.this.settings.setLong(OptionsForm.class.getName() + "@max_rows", maxRows);
                JTestRunLog.this.errorsOnly = JTestRunLog.this.optionsDialog.getBooleanValue("Errors Only");
                JTestRunLog.this.settings.setBoolean(OptionsForm.class.getName() + "@errors_only", JTestRunLog.this.errorsOnly);
                JTestRunLog.this.follow = JTestRunLog.this.optionsDialog.getBooleanValue("Follow");
            }
        }
    }

    private final class LogListMouseListener
    extends MouseAdapter {
        private LogListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TestStepResult result;
            int index = JTestRunLog.this.testLogList.getSelectedIndex();
            if (index != -1 && (index == JTestRunLog.this.selectedIndex || e.getClickCount() > 1) && (result = JTestRunLog.this.logListModel.getResultAt(index)) != null && result.getActions() != null) {
                result.getActions().performDefaultAction(new ActionEvent(this, 0, null));
            }
            JTestRunLog.this.selectedIndex = index;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void showPopup(MouseEvent e) {
            TestStepResult result;
            int row = JTestRunLog.this.testLogList.locationToIndex(e.getPoint());
            if (row == -1) {
                return;
            }
            if (JTestRunLog.this.testLogList.getSelectedIndex() != row) {
                JTestRunLog.this.testLogList.setSelectedIndex(row);
            }
            if ((result = JTestRunLog.this.logListModel.getResultAt(row)) == null) {
                return;
            }
            ActionList actions = result.getActions();
            if (actions == null || actions.getActionCount() == 0) {
                return;
            }
            JPopupMenu popup = ActionSupport.buildPopup(actions);
            UISupport.showPopup(popup, JTestRunLog.this.testLogList, e.getPoint());
        }
    }

    private final class TestLogCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Font boldFont;
        private Font normalFont;
        private JHyperlinkLabel hyperlinkLabel = new JHyperlinkLabel("");

        public TestLogCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.setIcon(null);
            this.boldFont = this.getFont().deriveFont(1);
            this.normalFont = this.getFont();
            this.hyperlinkLabel.setOpaque(true);
            this.hyperlinkLabel.setForeground(Color.BLUE.darker().darker().darker());
            this.hyperlinkLabel.setUnderlineColor(Color.GRAY);
            this.hyperlinkLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof String) {
                this.setText(value.toString());
            } else if (value instanceof TestCaseLogItem) {
                TestCaseLogItem logItem = (TestCaseLogItem)value;
                String msg = logItem.getMsg();
                this.setText(msg == null ? "" : msg);
            }
            TestStepResult result = JTestRunLog.this.logListModel.getResultAt(index);
            if (result != null && !this.getText().startsWith(" ->")) {
                this.hyperlinkLabel.setText(this.getText());
                this.hyperlinkLabel.setBackground(this.getBackground());
                this.hyperlinkLabel.setEnabled(list.isEnabled());
                if (result.getStatus() == TestStepResult.TestStepStatus.OK) {
                    this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                } else if (result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                    this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                } else {
                    this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/unknown_assertion.gif"));
                }
                return this.hyperlinkLabel;
            }
            this.setEnabled(list.isEnabled());
            if (JTestRunLog.this.boldTexts.contains(this.getText())) {
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.normalFont);
            }
            return this;
        }
    }
}

