/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.DocumentContent;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;

public class MockResponseXmlDocument
extends AbstractXmlDocument
implements PropertyChangeListener {
    private final MockResponse mockResponse;

    public MockResponseXmlDocument(MockResponse response) {
        this.mockResponse = response;
        this.mockResponse.addPropertyChangeListener(WsdlMockResponse.RESPONSE_CONTENT_PROPERTY, this);
    }

    @Override
    public SchemaTypeSystem getTypeSystem() {
        try {
            WsdlOperation operation;
            if (this.mockResponse instanceof WsdlMockResponse && (operation = (WsdlOperation)this.mockResponse.getMockOperation().getOperation()) != null) {
                WsdlInterface iface = operation.getInterface();
                WsdlContext wsdlContext = iface.getWsdlContext();
                return wsdlContext.getSchemaTypeSystem();
            }
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
        }
        return XmlBeans.getBuiltinTypeSystem();
    }

    @Override
    public void setDocumentContent(DocumentContent documentContent) {
        this.mockResponse.setResponseContent(documentContent.getContentAsString());
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.fireContentChanged();
    }

    @Override
    public void release() {
        this.mockResponse.removePropertyChangeListener(WsdlMockResponse.RESPONSE_CONTENT_PROPERTY, this);
        super.release();
    }

    @Override
    @Nonnull
    public DocumentContent getDocumentContent(EditorDocument.Format format) {
        return new DocumentContent(this.mockResponse.getContentType(), this.mockResponse.getResponseContent());
    }
}

