/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor.jettyproxy;

import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.ProxyServlet;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CapturedExchange {
    private boolean startCapture;
    private boolean stopCapture;
    private long operationStarted;
    private long timeTaken;
    private String requestHost;
    private String targetHost;
    private String wsInterface;
    private String wsOperation;
    private int requestSize;
    private int responseSize;
    private byte[] request;
    private byte[] response;
    private String requestHeader;
    private String responseHeader;

    public boolean isStartCapture() {
        return this.startCapture;
    }

    public void startCapture() {
        this.startCapture = true;
        this.stopCapture = false;
        this.setOperationStarted(System.currentTimeMillis());
    }

    public boolean isStopCapture() {
        return this.stopCapture;
    }

    public void stopCapture() {
        this.startCapture = false;
        this.stopCapture = true;
        this.setTimeTaken(System.currentTimeMillis());
    }

    public long getOperationStarted() {
        return this.operationStarted;
    }

    private void setOperationStarted(long operationStarted) {
        this.operationStarted = operationStarted;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public void setTargetHost(String targetHost) {
        this.targetHost = targetHost;
    }

    public String getWsInterface() {
        return this.wsInterface;
    }

    public void setWsInterface(String wsInterface) {
        this.wsInterface = wsInterface;
    }

    public String getWsOperation() {
        return this.wsOperation;
    }

    public void setWsOperation(String wsOperation) {
        this.wsOperation = wsOperation;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    private void setTimeTaken(long endTime) {
        this.timeTaken = -this.operationStarted + endTime;
    }

    public int getRequestSize() {
        return this.requestSize;
    }

    private void setRequestSize(int requestSizeInCharacters) {
        this.requestSize = requestSizeInCharacters;
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    private void setResponseSize() {
        int length;
        this.responseSize = length = this.response.length;
    }

    public byte[] getRequest() {
        return this.request;
    }

    public void setRequest(byte[] request) {
        if (this.request == null) {
            this.request = request;
        } else {
            int i;
            byte[] newRequest = new byte[this.request.length + request.length];
            for (i = 0; i < this.request.length; ++i) {
                newRequest[i] = this.request[i];
            }
            for (i = this.request.length; i < newRequest.length; ++i) {
                newRequest[i] = request[i - this.response.length];
            }
            this.request = newRequest;
        }
        this.setRequestSize(this.request.length);
    }

    public byte[] getResponse() {
        return this.response;
    }

    public void setResponse(byte[] response) {
        if (this.response == null) {
            this.response = response;
        } else {
            int i;
            byte[] newResponse = new byte[this.response.length + response.length];
            for (i = 0; i < this.response.length; ++i) {
                newResponse[i] = this.response[i];
            }
            for (i = this.response.length; i < newResponse.length; ++i) {
                newResponse[i] = response[i - this.response.length];
            }
            this.response = newResponse;
        }
        this.setResponseSize();
    }

    public String toString() {
        String toString = "Request host: " + this.requestHost + "\n";
        toString = toString + "Request header : \n" + this.requestHeader + "\n";
        toString = toString + "Request: " + new String(this.request) + "\n";
        toString = toString + "Request size: " + this.requestSize + "\n";
        toString = toString + "Response host:" + this.targetHost + "\n";
        toString = toString + "Response header: \n" + this.responseHeader + "\n";
        toString = toString + "Response: " + new String(this.response) + "\n";
        toString = toString + "Response size:" + this.responseSize + "\n";
        toString = toString + "Started: " + new Date(this.operationStarted) + "\n";
        toString = toString + "Time Taken: " + this.timeTaken + "ms\n";
        return toString;
    }

    public void setRequestHeader(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String headerValue = null;
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (ProxyServlet.dontProxyHeaders.contains(name.toLowerCase())) continue;
            headerValue = name + "::";
            Enumeration header = httpRequest.getHeaders(name);
            while (header.hasMoreElements()) {
                String value = (String)header.nextElement();
                if (value == null) continue;
                headerValue = headerValue + value;
            }
            this.requestHeader = this.requestHeader == null ? headerValue : this.requestHeader + "\n" + headerValue;
        }
    }

    public void addResponseHeader(String responseHeader) {
        this.responseHeader = this.responseHeader == null ? responseHeader : this.responseHeader + "\n" + responseHeader;
    }
}

