/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.data.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JStatisticsHistoryGraph;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.table.TableModel;

public class ExportSamplesHistoryAction
extends AbstractAction {
    private final JStatisticsHistoryGraph graph;

    public ExportSamplesHistoryAction(JStatisticsHistoryGraph historyGraph) {
        this.putValue("SmallIcon", UISupport.createImageIcon("/export.gif"));
        this.putValue("ShortDescription", "Export samples history to a file");
        this.graph = historyGraph;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            TableModel model = this.graph.getModel();
            if (model.getRowCount() == 0) {
                UISupport.showErrorMessage("No data to export!");
                return;
            }
            File file = UISupport.getFileDialogs().saveAs(this, "Select file for export");
            if (file == null) {
                return;
            }
            int cnt = this.exportToFile(file, model);
            UISupport.showInfoMessage("Saved " + cnt + " rows to file [" + file.getName() + "]");
        }
        catch (IOException e1) {
            SoapUI.logError(e1);
        }
    }

    private int exportToFile(File file, TableModel model) throws IOException {
        PrintWriter writer = new PrintWriter(file);
        this.writerHeader(writer, model);
        int cnt = this.writeData(writer, model);
        writer.flush();
        writer.close();
        return cnt;
    }

    private int writeData(PrintWriter writer, TableModel model) {
        int c;
        for (c = 0; c < model.getRowCount(); ++c) {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                if (i > 0) {
                    writer.print(',');
                }
                writer.print(model.getValueAt(c, i));
            }
            writer.println();
        }
        return c;
    }

    private void writerHeader(PrintWriter writer, TableModel model) {
        for (int i = 0; i < model.getColumnCount(); ++i) {
            if (i > 0) {
                writer.print(',');
            }
            writer.print(model.getColumnName(i));
        }
        writer.println();
    }
}

