/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.data;

import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStepSample;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class LoadTestSamples
extends AbstractTableModel {
    private final LoadTest loadTest;
    private List<List<LoadTestStepSample[]>> samples = new ArrayList<List<LoadTestStepSample[]>>();
    private List<Long> timestamps = new ArrayList<Long>();
    private InternalLoadTestRunListener loadTestRunListener = new InternalLoadTestRunListener();
    private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private static final Logger log = Logger.getLogger(LoadTestSamples.class);

    public LoadTestSamples(LoadTest loadTest) {
        this.loadTest = loadTest;
        loadTest.addLoadTestRunListener(this.loadTestRunListener);
        loadTest.getTestCase().getTestSuite().addTestSuiteListener(this.testSuiteListener);
    }

    @Override
    public int getRowCount() {
        return this.samples.size();
    }

    public void release() {
        this.loadTest.removeLoadTestRunListener(this.loadTestRunListener);
        this.loadTest.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
    }

    @Override
    public int getColumnCount() {
        return this.loadTest.getTestCase().getTestStepCount() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return columnIndex == 0 ? new Date(this.timestamps.get(rowIndex)) : (Cloneable)this.samples.get(rowIndex).get(columnIndex - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Date.class : LoadTestStepSample[].class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Timestamp" : this.loadTest.getTestCase().getTestStepAt(columnIndex - 1).getName();
    }

    public synchronized void clear() {
        int size = this.samples.size();
        this.samples.clear();
        this.timestamps.clear();
        this.fireTableRowsDeleted(0, size - 1);
    }

    private class InternalLoadTestRunListener
    extends LoadTestRunListenerAdapter {
        private InternalLoadTestRunListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
            long timestamp = System.currentTimeMillis();
            ArrayList<LoadTestStepSample[]> s = new ArrayList<LoadTestStepSample[]>();
            List<TestStepResult> testResults = testRunner.getResults();
            for (int c = 0; c < LoadTestSamples.this.loadTest.getTestCase().getTestStepCount(); ++c) {
                TestStep testStep = LoadTestSamples.this.loadTest.getTestCase().getTestStepAt(c);
                ArrayList<LoadTestStepSample> results = new ArrayList<LoadTestStepSample>();
                for (int i = 0; i < testResults.size(); ++i) {
                    TestStepResult stepResult = testResults.get(i);
                    if (stepResult == null) {
                        log.warn((Object)("Result [" + c + "] is null in TestCase [" + testRunner.getTestCase().getName() + "]"));
                        continue;
                    }
                    if (!stepResult.getTestStep().equals(testStep)) continue;
                    results.add(new LoadTestStepSample(stepResult));
                }
                s.add(results.toArray(new LoadTestStepSample[results.size()]));
            }
            InternalLoadTestRunListener internalLoadTestRunListener = this;
            synchronized (internalLoadTestRunListener) {
                LoadTestSamples.this.samples.add(s);
                LoadTestSamples.this.timestamps.add(timestamp);
                LoadTestSamples.this.fireTableRowsInserted(LoadTestSamples.this.samples.size() - 1, LoadTestSamples.this.samples.size() - 1);
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        @Override
        public void loadTestRemoved(LoadTest loadTest) {
            if (loadTest.equals(LoadTestSamples.this.loadTest)) {
                loadTest.removeLoadTestRunListener(LoadTestSamples.this.loadTestRunListener);
            }
        }

        @Override
        public void testStepAdded(TestStep testStep, int index) {
            if (testStep.getTestCase() == LoadTestSamples.this.loadTest.getTestCase()) {
                for (List values : LoadTestSamples.this.samples) {
                    values.add(index, new LoadTestStepSample[0]);
                }
            }
        }

        @Override
        public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
            if (testStep.getTestCase() == LoadTestSamples.this.loadTest.getTestCase()) {
                for (List values : LoadTestSamples.this.samples) {
                    LoadTestStepSample[] s = (LoadTestStepSample[])values.remove(fromIndex);
                    values.add(offset, s);
                }
            }
        }

        @Override
        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == LoadTestSamples.this.loadTest.getTestCase()) {
                for (List values : LoadTestSamples.this.samples) {
                    values.remove(index);
                }
            }
        }
    }
}

