/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

public class AddNewTestSuiteAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "AddNewTestSuiteAction";

    public AddNewTestSuiteAction() {
        super("New TestSuite", "Creates a new TestSuite in this project");
    }

    @Override
    public void perform(WsdlProject target, Object param) {
        this.createTestSuite(target);
    }

    public WsdlTestSuite createTestSuite(WsdlProject project) {
        String name = UISupport.prompt("Specify name of TestSuite", "New TestSuite", "TestSuite " + (project.getTestSuiteCount() + 1));
        if (name == null) {
            return null;
        }
        while (project.getTestSuiteByName(name.trim()) != null) {
            name = UISupport.prompt("Specify unique name of TestSuite", "Rename TestSuite", name);
        }
        WsdlTestSuite testSuite = project.addNewTestSuite(name);
        UISupport.showDesktopPanel(testSuite);
        return testSuite;
    }
}

