/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema;

import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.impl.wadl.inference.schema.particles.AttributeParticle;
import com.eviware.soapui.impl.wadl.inference.schema.particles.ElementParticle;
import com.eviware.soapui.impl.wadl.inference.schema.particles.ReferenceParticle;
import com.eviware.soapui.inferredSchema.AttributeParticleConfig;
import com.eviware.soapui.inferredSchema.ElementParticleConfig;
import com.eviware.soapui.inferredSchema.ParticleConfig;
import com.eviware.soapui.inferredSchema.ReferenceParticleConfig;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;

public interface Particle {
    public QName getName();

    public ParticleType getPType();

    public Type getType();

    public void setType(Type var1);

    public String getAttribute(String var1);

    public void setAttribute(String var1, String var2);

    public void validate(Context var1) throws XmlException;

    public ParticleConfig save();

    public static class Factory {
        public static Particle newElementInstance(Schema schema, String name) {
            return new ElementParticle(schema, name);
        }

        public static Particle newAttributeInstance(Schema schema, String name) {
            return new AttributeParticle(schema, name);
        }

        public static Particle newReferenceInstance(Schema schema, Particle reference) {
            return new ReferenceParticle(schema, reference);
        }

        public static Particle parse(ParticleConfig xml, Schema schema) {
            if (xml instanceof AttributeParticleConfig) {
                return new AttributeParticle((AttributeParticleConfig)xml, schema);
            }
            if (xml instanceof ElementParticleConfig) {
                return new ElementParticle((ElementParticleConfig)xml, schema);
            }
            if (xml instanceof ReferenceParticleConfig) {
                return new ReferenceParticle((ReferenceParticleConfig)xml, schema);
            }
            return null;
        }
    }

    public static enum ParticleType {
        ATTRIBUTE("attribute"),
        ELEMENT("element");

        private final String name;

        private ParticleType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

