/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.Response;

public class BaseMockResult<MockRequestType extends MockRequest, MockOperationType extends MockOperation>
implements MockResult {
    private MockResponse mockResponse;
    private String responseContent;
    private long timeTaken;
    private long timestamp;
    private DefaultActionList actions;
    private StringToStringsMap responseHeaders = new StringToStringsMap();
    private MockRequestType mockRequest;
    private byte[] rawResponseData;
    private MockOperationType mockOperation;
    private String responseContentType;

    public BaseMockResult(MockRequestType request) {
        this.timestamp = System.currentTimeMillis();
        this.mockRequest = request;
    }

    public MockRequestType getMockRequest() {
        return this.mockRequest;
    }

    @Override
    public ActionList getActions() {
        if (this.actions == null) {
            this.actions = new DefaultActionList("MockResult");
        }
        return this.actions;
    }

    @Override
    public MockResponse getMockResponse() {
        return this.mockResponse;
    }

    @Override
    public String getResponseContent() {
        return this.responseContent;
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setMockResponse(MockResponse mockResponse) {
        this.mockResponse = mockResponse;
        this.mockRequest.getRequestContext().setMockResponse(mockResponse);
    }

    @Override
    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    @Override
    public void finish() {
        if (this.mockRequest.getHttpResponse() instanceof Response) {
            HttpFields httpFields = ((Response)this.mockRequest.getHttpResponse()).getHttpFields();
            Enumeration e = httpFields.getFieldNames();
            while (e.hasMoreElements()) {
                String nextElement = (String)e.nextElement();
                this.responseHeaders.add(nextElement, httpFields.getStringField(nextElement));
            }
        }
    }

    @Override
    public void addHeader(String name, String value) {
        HttpServletResponse httpResponse = this.mockRequest.getHttpResponse();
        if (httpResponse != null) {
            httpResponse.addHeader(name, value);
        }
        this.responseHeaders.add(name, value);
    }

    @Override
    public boolean isCommitted() {
        return this.mockRequest.getHttpResponse().isCommitted();
    }

    @Override
    public void setContentType(String contentType) {
        this.mockRequest.getHttpResponse().setContentType(contentType);
        this.responseContentType = contentType;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mockRequest.getHttpResponse().getOutputStream();
    }

    public boolean isDiscarded() {
        return false;
    }

    @Override
    public byte[] getRawResponseData() {
        return this.rawResponseData;
    }

    public void setRawResponseData(byte[] rawResponseData) {
        this.rawResponseData = rawResponseData;
    }

    @Override
    public void writeRawResponseData(byte[] bs) throws IOException {
        this.getOutputStream().write(bs);
        this.setRawResponseData(bs);
    }

    public void setMockOperation(MockOperationType mockOperation) {
        this.mockOperation = mockOperation;
    }

    @Override
    public MockOperation getMockOperation() {
        if (this.mockOperation != null) {
            return this.mockOperation;
        }
        return this.mockResponse == null ? null : this.mockResponse.getMockOperation();
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder(DateUtil.formatExtraFull(new Date(this.getTimestamp())));
        MockResponse mockResponse = this.getMockResponse();
        if (mockResponse == null) {
            msg.append(": [dispatch error; missing response]");
        } else {
            try {
                msg.append(": [" + mockResponse.getMockOperation().getName());
            }
            catch (Throwable e) {
                msg.append(": [removed operation?]");
            }
            msg.append("] " + this.getTimeTaken() + "ms");
        }
        return msg.toString();
    }
}

