/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.resource;

import com.eviware.soapui.impl.rest.actions.support.NewRestResourceActionBase;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTableModel;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AddParamAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.MovePropertyDownAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.MovePropertyUpAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.RemovePropertyAction;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.components.StringListFormComponent;
import com.eviware.soapui.support.swing.JTableFactory;
import com.jgoodies.binding.PresentationModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;

public class RestParamsTable
extends JPanel {
    public static final String REST_PARAMS_TABLE = "RestParamsTable";
    public static final String REVERT_PARAMETER_VALUES = "Revert Parameter Values";
    protected RestParamsPropertyHolder params;
    protected RestParamsTableModel paramsTableModel;
    protected JTable paramsTable;
    protected AddParamAction addParamAction = null;
    protected RemovePropertyAction removeParamAction = null;
    protected UseDefaultParamsAction defaultParamsAction = null;
    protected MovePropertyDownAction movePropertyDownAction = null;
    protected MovePropertyUpAction movePropertyUpAction = null;
    protected UpdateParamsAction updateParamsAction = null;
    private PresentationModel<RestParamProperty> paramDetailsModel;
    private SimpleBindingForm detailsForm;
    private NewRestResourceActionBase.ParamLocation defaultParamLocation;
    private boolean showEditableButtons;
    private boolean showDefaultParamsButton;
    private JSplitPane splitPane;
    private JScrollPane scrollPane;

    public RestParamsTable(RestParamsPropertyHolder params, boolean showInspector, NewRestResourceActionBase.ParamLocation defaultParamLocation, boolean showEditableButtons, boolean showDefaultParamsButton) {
        this(params, showInspector, new RestParamsTableModel(params, RestParamsTableModel.Mode.MEDIUM), defaultParamLocation, showEditableButtons, showDefaultParamsButton);
    }

    public RestParamsTable(RestParamsPropertyHolder params, boolean showInspector, RestParamsTableModel model, NewRestResourceActionBase.ParamLocation defaultParamLocation, boolean showEditableButtons, boolean showDefaultParamsButton) {
        super(new BorderLayout());
        this.defaultParamLocation = defaultParamLocation;
        this.showEditableButtons = showEditableButtons;
        this.showDefaultParamsButton = showDefaultParamsButton;
        this.params = params;
        this.paramsTableModel = model;
        this.init(showInspector);
    }

    protected void init(boolean showInspector) {
        this.paramsTable = new JTable(this.paramsTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component defaultRenderer = super.prepareRenderer(renderer, row, column);
                if (UISupport.isMac()) {
                    JTableFactory.applyStripesToRenderer(row, defaultRenderer);
                }
                return defaultRenderer;
            }

            @Override
            public void removeEditor() {
                TableCellEditor editor = this.getCellEditor();
                super.removeEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                }
            }

            @Override
            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                JComboBox comboBox;
                RestParamProperty parameter;
                Component component = super.prepareEditor(editor, row, column);
                if (this.getColumnClass(column) == RestParamsPropertyHolder.ParameterStyle.class) {
                    parameter = RestParamsTable.this.paramsTableModel.getParameterAt(row);
                    comboBox = (JComboBox)((DefaultCellEditor)editor).getComponent();
                    comboBox.setModel(RestParamsTable.this.getStylesForLocation(parameter.getParamLocation()));
                    super.prepareEditor(editor, row, column);
                }
                if (this.getColumnClass(column) == NewRestResourceActionBase.ParamLocation.class) {
                    parameter = RestParamsTable.this.paramsTableModel.getParameterAt(row);
                    comboBox = (JComboBox)((DefaultCellEditor)editor).getComponent();
                    comboBox.setModel(RestParamsTable.this.getLocationForParameter(parameter.getStyle()));
                    super.prepareEditor(editor, row, column);
                }
                return component;
            }
        };
        this.paramsTable.setName(REST_PARAMS_TABLE);
        this.paramsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (this.showDefaultParamsButton) {
            this.defaultParamsAction = new UseDefaultParamsAction();
        }
        this.movePropertyDownAction = new MovePropertyDownAction(this.paramsTable, this.params, "Moves selected parameter down one row");
        this.movePropertyUpAction = new MovePropertyUpAction(this.paramsTable, this.params, "Moves selected parameter up one row");
        if (this.showEditableButtons) {
            this.initEditableButtons();
        }
        this.paramsTable.setSelectionMode(0);
        this.paramsTable.setDefaultEditor(RestParamsPropertyHolder.ParameterStyle.class, new DefaultCellEditor(new JComboBox(this.getStylesForLocation(NewRestResourceActionBase.ParamLocation.RESOURCE))));
        this.paramsTable.setDefaultEditor(NewRestResourceActionBase.ParamLocation.class, new DefaultCellEditor(new JComboBox<NewRestResourceActionBase.ParamLocation>(NewRestResourceActionBase.ParamLocation.values())));
        this.paramsTable.setRowHeight(25);
        this.paramsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = RestParamsTable.this.paramsTable.getSelectedRow();
                if (RestParamsTable.this.showEditableButtons) {
                    RestParamsTable.this.removeParamAction.setEnabled(selectedRow != -1);
                }
                if (RestParamsTable.this.showDefaultParamsButton) {
                    RestParamsTable.this.defaultParamsAction.setEnabled(RestParamsTable.this.paramsTable.getRowCount() > 0);
                }
                RestParamsTable.this.movePropertyDownAction.setEnabled(selectedRow < RestParamsTable.this.paramsTable.getRowCount() - 1);
                RestParamsTable.this.movePropertyUpAction.setEnabled(selectedRow > 0);
                if (selectedRow != -1) {
                    RestParamProperty selectedParameter = RestParamsTable.this.getSelectedParameter();
                    if (RestParamsTable.this.paramDetailsModel != null) {
                        RestParamsTable.this.updateDetailsFormWith(selectedParameter);
                        RestParamsTable.this.detailsForm.setEnabled(true);
                    }
                } else if (RestParamsTable.this.paramDetailsModel != null) {
                    RestParamsTable.this.detailsForm.setEnabled(false);
                    RestParamsTable.this.updateDetailsFormWith(null);
                }
            }
        });
        this.add(this.buildToolbar(), "North");
        this.scrollPane = new JScrollPane(this.paramsTable);
        if (showInspector) {
            this.splitPane = UISupport.createVerticalSplit(this.scrollPane, this.buildDetails());
            this.add((Component)this.splitPane, "Center");
            this.splitPane.setResizeWeight(0.7);
        } else {
            this.add((Component)this.scrollPane, "Center");
        }
    }

    private DefaultComboBoxModel getStylesForLocation(NewRestResourceActionBase.ParamLocation paramLocation) {
        if (paramLocation == NewRestResourceActionBase.ParamLocation.METHOD) {
            return new DefaultComboBoxModel<RestParamsPropertyHolder.ParameterStyle>(new RestParamsPropertyHolder.ParameterStyle[]{RestParamsPropertyHolder.ParameterStyle.QUERY, RestParamsPropertyHolder.ParameterStyle.HEADER, RestParamsPropertyHolder.ParameterStyle.MATRIX, RestParamsPropertyHolder.ParameterStyle.PLAIN});
        }
        return new DefaultComboBoxModel<RestParamsPropertyHolder.ParameterStyle>(new RestParamsPropertyHolder.ParameterStyle[]{RestParamsPropertyHolder.ParameterStyle.QUERY, RestParamsPropertyHolder.ParameterStyle.TEMPLATE, RestParamsPropertyHolder.ParameterStyle.HEADER, RestParamsPropertyHolder.ParameterStyle.MATRIX, RestParamsPropertyHolder.ParameterStyle.PLAIN});
    }

    private DefaultComboBoxModel getLocationForParameter(RestParamsPropertyHolder.ParameterStyle style) {
        if (style != RestParamsPropertyHolder.ParameterStyle.TEMPLATE) {
            return new DefaultComboBoxModel<NewRestResourceActionBase.ParamLocation>(new NewRestResourceActionBase.ParamLocation[]{NewRestResourceActionBase.ParamLocation.RESOURCE, NewRestResourceActionBase.ParamLocation.METHOD});
        }
        return new DefaultComboBoxModel<NewRestResourceActionBase.ParamLocation>(new NewRestResourceActionBase.ParamLocation[]{NewRestResourceActionBase.ParamLocation.RESOURCE});
    }

    private void updateDetailsFormWith(RestParamProperty selectedParameter) {
        try {
            this.paramDetailsModel.setBean((Object)selectedParameter);
        }
        catch (Exception e) {
            this.splitPane.setBottomComponent(this.buildDetails());
            this.paramDetailsModel.setBean((Object)selectedParameter);
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.paramsTable.addKeyListener(l);
    }

    private void initEditableButtons() {
        this.addParamAction = new AddParamAction(this.paramsTable, this.params, "Adds a parameter to the parameter table");
        this.removeParamAction = new RemovePropertyAction(this.paramsTable, this.params, "Removes the selected parameter");
        this.updateParamsAction = new UpdateParamsAction();
    }

    private JComponent buildDetails() {
        this.paramDetailsModel = new PresentationModel(null);
        this.detailsForm = new SimpleBindingForm(this.paramDetailsModel);
        this.detailsForm.addSpace(5);
        this.detailsForm.appendCheckBox("required", "Required", "Sets if parameter is required");
        ArrayList<QName> types = new ArrayList<QName>();
        for (SchemaType type : XmlBeans.getBuiltinTypeSystem().globalTypes()) {
            types.add(type.getName());
        }
        this.detailsForm.appendComboBox("type", "Type", types.toArray(), "The type of the parameter");
        StringListFormComponent optionsFormComponent = new StringListFormComponent("Available values for this Parameter");
        optionsFormComponent.setPreferredSize(new Dimension(350, 100));
        this.detailsForm.appendComponent("options", "Options", optionsFormComponent);
        this.detailsForm.appendTextField("description", "Description", "A short description of the parameter");
        this.detailsForm.appendCheckBox("disableUrlEncoding", "Disable Encoding", "Disables URL-Encoding of the parameter value");
        this.detailsForm.addSpace(5);
        this.detailsForm.setEnabled(false);
        return new JScrollPane(this.detailsForm.getPanel());
    }

    protected RestParamProperty getSelectedParameter() {
        return this.paramsTable.getSelectedRow() == -1 ? null : this.paramsTableModel.getParameterAt(this.paramsTable.getSelectedRow());
    }

    public JTable getParamsTable() {
        return this.paramsTable;
    }

    public void release() {
        this.paramsTableModel.release();
        if (this.paramDetailsModel != null) {
            this.paramDetailsModel.setBean(null);
        }
    }

    protected Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        if (this.showEditableButtons) {
            toolbar.add(UISupport.createToolbarButton(this.addParamAction));
            toolbar.add(UISupport.createToolbarButton(this.removeParamAction, false));
            toolbar.addSeparator();
            toolbar.add(UISupport.createToolbarButton(this.updateParamsAction));
        }
        if (this.showDefaultParamsButton) {
            toolbar.add(UISupport.createToolbarButton(this.defaultParamsAction, this.paramsTable.getRowCount() > 0));
        }
        toolbar.addSeparator();
        if (!this.inMinimalMode()) {
            toolbar.add(UISupport.createToolbarButton(this.movePropertyDownAction, false));
            toolbar.add(UISupport.createToolbarButton(this.movePropertyUpAction, false));
        }
        toolbar.addSeparator();
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/REST-Testing/understanding-rest-parameters.html")));
        return toolbar;
    }

    private boolean inMinimalMode() {
        RestParamsTableModel tableModel = (RestParamsTableModel)this.getParamsTable().getModel();
        return tableModel.isInMinimalMode();
    }

    public void extractParams(RestParamsPropertyHolder params, NewRestResourceActionBase.ParamLocation location) {
        for (int i = 0; i < this.paramsTable.getRowCount(); ++i) {
            RestParamProperty prop = this.paramsTableModel.getParameterAt(i);
            if (this.paramsTableModel.getParamLocationAt(i) != location) continue;
            params.addParameter(prop);
        }
    }

    public void focusParameter(String parameterName) {
        this.paramsTable.grabFocus();
        for (int i = 0; i < this.paramsTable.getRowCount(); ++i) {
            if (!this.paramsTable.getValueAt(i, 0).equals(parameterName)) continue;
            this.paramsTable.setRowSelectionInterval(i, i);
            this.paramsTable.editCellAt(i, 1);
            JTextField editorComponent = (JTextField)this.paramsTable.getEditorComponent();
            editorComponent.grabFocus();
            editorComponent.selectAll();
            this.scrollIntoPosition(i, this.paramsTable.getRowCount());
            return;
        }
    }

    private void scrollIntoPosition(int selectedIndex, int numOfIndices) {
        this.scrollIntoPosition((double)selectedIndex / (double)numOfIndices);
    }

    private void scrollIntoPosition(double percent) {
        int maximumScrollPosition = this.scrollPane.getVerticalScrollBar().getMaximum();
        int requestedScrollPosition = (int)Math.round((double)maximumScrollPosition * percent);
        this.scrollPane.getVerticalScrollBar().setValue(requestedScrollPosition);
    }

    public void setParams(RestParamsPropertyHolder params) {
        this.params = params;
        this.paramsTableModel.setParams(params);
    }

    public void refresh() {
        this.paramsTableModel.fireTableDataChanged();
    }

    private class UseDefaultParamsAction
    extends AbstractAction {
        public UseDefaultParamsAction() {
            super(RestParamsTable.REVERT_PARAMETER_VALUES);
            this.putValue("SmallIcon", UISupport.createImageIcon("/default_properties.gif"));
            this.putValue("ShortDescription", "Reverts all current parameters to default values");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Revert all parameters to default values?", "Use Defaults")) {
                for (TestProperty property : RestParamsTable.this.params.getProperties().values()) {
                    property.setValue(null);
                }
            }
        }
    }

    private class UpdateParamsAction
    extends AbstractAction {
        private UpdateParamsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/update-request-parameters-from-url.png"));
            this.putValue("ShortDescription", "Updates params from a specified URL");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String str = UISupport.prompt("Enter new url below", "Extract Params", "");
            if (str == null) {
                return;
            }
            try {
                RestUtils.extractParams(str, RestParamsTable.this.params, false, RestParamsTable.this.defaultParamLocation == NewRestResourceActionBase.ParamLocation.RESOURCE ? RestUtils.TemplateExtractionOption.EXTRACT_TEMPLATE_PARAMETERS : RestUtils.TemplateExtractionOption.IGNORE_TEMPLATE_PARAMETERS);
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }
}

