/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.actions.support.NewRestResourceActionBase;
import com.eviware.soapui.impl.rest.panels.request.ParameterFinder;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTableModel;
import com.eviware.soapui.impl.rest.support.RestUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

class ParametersField
extends JPanel {
    public static final String PARAMETERS_FIELD = "ParametersField";
    private final RestRequestInterface request;
    private final JLabel textLabel;
    private final JTextField textField;
    private int lastSelectedPosition;

    ParametersField(RestRequestInterface request) {
        this.request = request;
        this.textLabel = new JLabel("Parameters");
        String paramsString = RestUtils.makeSuffixParameterString(request);
        this.textField = new JTextField(paramsString);
        this.textField.setEditable(false);
        this.textField.setCursor(Cursor.getPredefinedCursor(2));
        this.textField.setBackground(Color.WHITE);
        this.textField.setName(PARAMETERS_FIELD);
        this.setToolTipText(paramsString);
        super.setLayout(new BorderLayout());
        super.add((Component)this.textLabel, "North");
        super.add((Component)this.textField, "South");
        this.addListeners();
    }

    private void addListeners() {
        this.textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                final ParameterFinder finder = new ParameterFinder(ParametersField.this.textField.getText());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ParametersField.this.openPopup(finder.findParameterAt(ParametersField.this.lastSelectedPosition));
                    }
                });
            }
        });
        this.textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ParametersField.this.lastSelectedPosition = e.getDot();
            }
        });
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
        this.setToolTipText(text);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.textLabel.setToolTipText(text);
        this.textField.setToolTipText(text);
    }

    private void openPopup(String selectedParameter) {
        RestParamsTable restParamsTable = new RestParamsTable(this.request.getParams(), false, new RestParamsTableModel(this.request.getParams(), RestParamsTableModel.Mode.MINIMAL), NewRestResourceActionBase.ParamLocation.RESOURCE, true, true);
        this.showParametersTableInWindow(restParamsTable, selectedParameter);
    }

    private void showParametersTableInWindow(RestParamsTable restParamsTable, String selectedParameter) {
        PopupWindow popupWindow = new PopupWindow(restParamsTable);
        popupWindow.pack();
        restParamsTable.focusParameter(selectedParameter);
        this.moveWindowBelowTextField(popupWindow);
        popupWindow.setModal(true);
        popupWindow.setVisible(true);
    }

    private void moveWindowBelowTextField(PopupWindow popupWindow) {
        try {
            Point textFieldLocation = this.textField.getLocationOnScreen();
            popupWindow.setLocation(textFieldLocation.x, textFieldLocation.y + this.textField.getHeight());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void updateTextField() {
        this.setText(RestUtils.makeSuffixParameterString(this.request));
    }

    private class PopupWindow
    extends JDialog {
        private final JButton closeButton;
        private RestParamsTable restParamsTable;

        private PopupWindow(RestParamsTable restParamsTable) {
            super(SoapUI.getFrame());
            this.setResizable(false);
            this.restParamsTable = restParamsTable;
            this.getContentPane().setLayout(new BorderLayout());
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            this.closeButton = new JButton("Close");
            this.getRootPane().setDefaultButton(this.closeButton);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupWindow.this.close();
                }
            });
            buttonPanel.add(this.closeButton);
            this.getContentPane().add((Component)restParamsTable, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.closeButton.getInputMap(2).put(KeyStroke.getKeyStroke('\u001b'), "closePopup");
            this.closeButton.getActionMap().put("closePopup", new CloseAction());
        }

        private void close() {
            JTable actualTable = this.restParamsTable.getParamsTable();
            if (actualTable.isEditing()) {
                actualTable.getCellEditor().stopCellEditing();
            }
            this.setVisible(false);
            this.dispose();
        }

        private class CloseAction
        implements Action {
            private CloseAction() {
            }

            @Override
            public Object getValue(String key) {
                return null;
            }

            @Override
            public void putValue(String key, Object value) {
            }

            @Override
            public void setEnabled(boolean b) {
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupWindow.this.close();
            }
        }
    }
}

