/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.component;

import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.panels.component.RestResourceEditorPopupWindow;
import com.eviware.soapui.impl.rest.panels.component.RestResourceFinder;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import org.apache.commons.lang.mutable.MutableBoolean;

public class RestResourceEditor
extends JTextField {
    public static final String REST_RESOURCE_EDITOR_TEXT_FIELD = "RestResourceEditorTextField";
    MouseListener mouseListener;
    private RestResource editingRestResource;
    private MutableBoolean updating;
    private int lastSelectedPosition;

    public RestResourceEditor(final RestResource editingRestResource, MutableBoolean updating) {
        super(editingRestResource.getFullPath());
        this.editingRestResource = editingRestResource;
        this.updating = updating;
        this.setName(REST_RESOURCE_EDITOR_TEXT_FIELD);
        if (this.isResourceLonely(editingRestResource)) {
            this.getDocument().addDocumentListener(new LonelyDocumentListener());
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    RestResourceEditor.scanForTemplateParameters(editingRestResource);
                    this.removeMatrixParameters();
                }

                private void removeMatrixParameters() {
                    RestResourceEditor.this.setText(RestResourceEditor.this.getText().split(";")[0]);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        } else {
            Color originalBackground = this.getBackground();
            Border originalBorder = this.getBorder();
            this.setEditable(false);
            this.setBackground(originalBackground);
            this.setBorder(originalBorder);
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    final RestResource focusedResource = new RestResourceFinder(editingRestResource).findResourceAt(RestResourceEditor.this.lastSelectedPosition);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RestResourceEditor.this.openPopup(focusedResource);
                        }
                    });
                }
            };
            this.addMouseListener(this.mouseListener);
            this.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    RestResourceEditor.this.lastSelectedPosition = e.getDot();
                }
            });
        }
    }

    static void scanForTemplateParameters(RestResource resource) {
        for (RestResource restResource : RestUtils.extractAncestorsParentFirst(resource)) {
            for (String p : RestUtils.extractTemplateParams(restResource.getPath())) {
                if (RestResourceEditor.resourceOrParentHasProperty(restResource, p)) continue;
                RestParamProperty property = restResource.addProperty(p);
                property.setStyle(RestParamsPropertyHolder.ParameterStyle.TEMPLATE);
                String value = UISupport.prompt("Specify default value for parameter [" + p + "]", "Add Parameter", "");
                if (value == null) continue;
                property.setDefaultValue(value);
                property.setValue(value);
            }
        }
    }

    private static boolean resourceOrParentHasProperty(RestResource restResource, String name) {
        for (RestResource r = restResource; r != null; r = r.getParentResource()) {
            if (!r.hasProperty(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isResourceLonely(RestResource restResource) {
        return restResource.getParentResource() == null && StringUtils.isNullOrEmpty(restResource.getInterface().getBasePath());
    }

    public void openPopup(RestResource focusedResource) {
        RestResourceEditorPopupWindow popupWindow = new RestResourceEditorPopupWindow(this.editingRestResource, focusedResource);
        this.moveWindowBelowTextField(popupWindow);
        popupWindow.setVisible(true);
    }

    private void moveWindowBelowTextField(RestResourceEditorPopupWindow popupWindow) {
        try {
            Point textFieldLocation = this.getLocationOnScreen();
            popupWindow.setLocation(textFieldLocation.x, textFieldLocation.y + this.getHeight());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    private class LonelyDocumentListener
    extends DocumentListenerAdapter {
        private LonelyDocumentListener() {
        }

        @Override
        public void update(Document document) {
            if (RestResourceEditor.this.updating.booleanValue()) {
                return;
            }
            RestResourceEditor.this.updating.setValue(true);
            RestResourceEditor.this.editingRestResource.setPath(this.getText(document).trim());
            RestResourceEditor.this.updating.setValue(false);
        }
    }
}

