/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.support;

import com.eviware.soapui.config.RestParametersConfig;
import com.eviware.soapui.impl.actions.RestUriDialogHandler;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public abstract class NewRestResourceActionBase<T extends ModelItem>
extends AbstractSoapUIAction<T> {
    public static final String CONFIRM_DIALOG_TITLE = "New REST Resource";
    public static final MessageSupport messages = MessageSupport.getMessages(NewRestResourceActionBase.class);

    public NewRestResourceActionBase(String title, String description) {
        super(title, description);
    }

    @Override
    public void perform(T parent, Object param) {
        RestUriDialogHandler dialogBuilder = new RestUriDialogHandler();
        XFormDialog dialog = dialogBuilder.buildDialog(messages);
        if (param instanceof URL) {
            XmlBeansRestParamsTestPropertyHolder params = new XmlBeansRestParamsTestPropertyHolder(null, RestParametersConfig.Factory.newInstance());
            String path = RestUtils.extractParams(param.toString(), params, false);
            dialog.setValue(Form.RESOURCEPATH, path);
        }
        if (dialog.show()) {
            String path = dialogBuilder.getUri();
            RestResource resource = this.createRestResource(parent, path);
            RestUtils.extractParams(dialog.getValue(Form.RESOURCEPATH), resource.getParams(), false);
            resource.setPath(this.removeParametersFrom(resource.getPath()));
            this.createMethodAndRequestFor(resource);
        }
    }

    protected RestResource createRestResource(T item, String path) {
        AbstractWsdlModelItem possibleParent = null;
        String pathWithoutEndpoint = this.removeEndpointFrom(path);
        for (RestResource resource : this.getResourcesFor(item)) {
            int c;
            if (!pathWithoutEndpoint.startsWith(resource.getFullPath() + "/")) continue;
            for (c = 0; c < resource.getChildResourceCount() && !pathWithoutEndpoint.startsWith(resource.getChildResourceAt(c).getFullPath() + "/"); ++c) {
            }
            if (c != resource.getChildResourceCount()) continue;
            possibleParent = resource;
            break;
        }
        if (possibleParent != null && UISupport.confirm("Create resource as child to [" + possibleParent.getName() + "]", CONFIRM_DIALOG_TITLE)) {
            String strippedPath = pathWithoutEndpoint;
            if (pathWithoutEndpoint.length() > 0 && ((RestResource)possibleParent).getFullPath().length() > 0) {
                strippedPath = pathWithoutEndpoint.substring(((RestResource)possibleParent).getFullPath().length() + 1);
            }
            return ((RestResource)possibleParent).addNewChildResource(this.extractNameFromPath(strippedPath), strippedPath);
        }
        String pathWithoutLeadingSlash = pathWithoutEndpoint.startsWith("/") ? pathWithoutEndpoint.substring(1) : pathWithoutEndpoint;
        return this.addResourceTo(item, this.extractNameFromPath(pathWithoutEndpoint), pathWithoutLeadingSlash);
    }

    protected abstract List<RestResource> getResourcesFor(T var1);

    protected abstract RestResource addResourceTo(T var1, String var2, String var3);

    private String removeEndpointFrom(String path) {
        try {
            return new URL(path).getPath();
        }
        catch (MalformedURLException ignore) {
            return path;
        }
    }

    private String extractNameFromPath(String path) {
        String strippedPath = this.removeParametersFrom(path);
        String[] items = strippedPath.split("/");
        return items.length == 0 ? "" : items[items.length - 1];
    }

    private String removeParametersFrom(String path) {
        String strippedPath;
        if (path.contains("?") || path.contains(";")) {
            int parametersIndex = this.findParametersIndex(path);
            strippedPath = path.substring(0, parametersIndex);
        } else {
            strippedPath = path;
        }
        return strippedPath;
    }

    private int findParametersIndex(String path) {
        int semicolonIndex = path.indexOf(59);
        int questionMarkIndex = path.indexOf(63);
        return Math.min(semicolonIndex == -1 ? Integer.MAX_VALUE : semicolonIndex, questionMarkIndex == -1 ? Integer.MAX_VALUE : questionMarkIndex);
    }

    private void createMethodAndRequestFor(RestResource resource) {
        RestMethod method = resource.addNewMethod("Method " + (resource.getRestMethodCount() + 1));
        method.setMethod(RestRequestInterface.HttpMethod.GET);
        RestRequest request = method.addNewRequest("Request " + (method.getRequestCount() + 1));
        UISupport.select(request);
        UISupport.showDesktopPanel(request);
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="http://www.soapui.org/REST-Testing/working-with-rest-services.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.ServiceUrl.Description", type=AField.AFieldType.STRING)
        public static final String RESOURCEPATH = messages.get("Form.ResourcePath.Label");
    }

    public static enum ParamLocation {
        RESOURCE,
        METHOD;

    }
}

