/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.InvalidOAuth2ParametersException;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2ClientFacade;
import com.eviware.soapui.impl.rest.actions.oauth.OltuOAuth2ClientFacade;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RefreshOAuthAccessTokenAction
extends AbstractAction {
    private OAuth2Profile profile;

    public RefreshOAuthAccessTokenAction(OAuth2Profile profile) {
        super("Refresh OAuth 2 access token");
        this.profile = profile;
        this.putValue("ShortDescription", "Refreshes an OAuth 2 the access token in the profile using the refresh token");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this.getOAuthClientFacade().refreshAccessToken(this.profile);
        }
        catch (InvalidOAuth2ParametersException e) {
            UISupport.showErrorMessage("Invalid OAuth2 parameters: " + e.getMessage());
        }
        catch (Exception e) {
            SoapUI.logError(e, "Error refreshing OAuth 2 access token");
            UISupport.showErrorMessage("Could not refresh access token. Check the SoapUI log for details");
        }
    }

    protected OAuth2ClientFacade getOAuthClientFacade() {
        return new OltuOAuth2ClientFacade();
    }
}

