/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.InvalidOAuth2ParametersException;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2Parameters;
import com.eviware.soapui.support.StringUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class OAuth2ParameterValidator {
    static void validate(OAuth2Parameters parameters) {
        OAuth2ParameterValidator.validateRequiredStringValue(parameters.clientId, "Client Identification");
        if (parameters.getOAuth2Flow() != OAuth2Profile.OAuth2Flow.IMPLICIT_GRANT) {
            OAuth2ParameterValidator.validateRequiredStringValue(parameters.clientSecret, "Client Secret");
            OAuth2ParameterValidator.validateHttpUrl(parameters.accessTokenUri, "Access Token URI");
        }
        OAuth2ParameterValidator.validateHttpUrl(parameters.authorizationUri, "Authorization URI");
        OAuth2ParameterValidator.validateUri(parameters.redirectUri, "Redirect URI");
    }

    private static void validateUri(String uri, String uriName) {
        if (!StringUtils.hasContent(uri)) {
            throw new InvalidOAuth2ParametersException(uri + " is not a valid " + uriName);
        }
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new InvalidOAuth2ParametersException(uri + " is not a valid " + uriName);
        }
    }

    private static void validateHttpUrl(String authorizationUri, String uriName) {
        if (!OAuth2ParameterValidator.isValidHttpUrl(authorizationUri)) {
            throw new InvalidOAuth2ParametersException(uriName + " " + authorizationUri + " is not a valid HTTP URL");
        }
    }

    private static boolean isValidHttpUrl(String authorizationUri) {
        if (!StringUtils.hasContent(authorizationUri)) {
            return false;
        }
        try {
            URL url = new URL(authorizationUri);
            return url.getProtocol().startsWith("http");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    static void validateRequiredStringValue(String value, String propertyName) {
        if (!StringUtils.hasContent(value)) {
            throw new InvalidOAuth2ParametersException(propertyName + " is empty");
        }
    }
}

