/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RestMethodConfig;
import com.eviware.soapui.config.RestRequestConfig;
import com.eviware.soapui.config.RestResourceRepresentationConfig;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.OverlayRestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.ui.desktop.AbstractSoapUIDesktop;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;

public class RestMethod
extends AbstractWsdlModelItem<RestMethodConfig>
implements MutableTestPropertyHolder,
PropertyChangeListener {
    private List<RestRequest> requests = new ArrayList<RestRequest>();
    private List<RestRepresentation> representations = new ArrayList<RestRepresentation>();
    private RestResource resource;
    private XmlBeansRestParamsTestPropertyHolder params;
    private RestParamsPropertyHolder overlayParams;
    private PropertyChangeListener representationPropertyChangeListener = new RepresentationPropertyChangeListener();
    private TestPropertyListener testPropertyListener = new InternalTestPropertyListener();

    public RestMethod(RestResource service, RestMethodConfig methodConfig) {
        super(methodConfig, service, "/" + (StringUtils.isNullOrEmpty(methodConfig.getMethod()) ? "get" : methodConfig.getMethod().toLowerCase()) + "_method.gif");
        this.resource = service;
        if (methodConfig.getParameters() == null) {
            methodConfig.addNewParameters();
        }
        this.params = new XmlBeansRestParamsTestPropertyHolder(this, methodConfig.getParameters());
        for (RestResourceRepresentationConfig restResourceRepresentationConfig : methodConfig.getRepresentationList()) {
            RestRepresentation representation = new RestRepresentation(this, restResourceRepresentationConfig);
            this.representations.add(representation);
            this.notifyPropertyChanged("representations", null, representation);
        }
        for (RestRequestConfig restRequestConfig : methodConfig.getRequestList()) {
            RestRequest request = new RestRequest(this, restRequestConfig, false);
            this.requests.add(request);
            this.notifyPropertyChanged("childRequests", null, request);
        }
        this.addTestPropertyListener(this.testPropertyListener);
    }

    public RestParamsPropertyHolder getOverlayParams() {
        if (this.overlayParams == null) {
            this.overlayParams = new OverlayRestParamsPropertyHolder(this.buildOverlay(this.getResource()), this.params);
        }
        return this.overlayParams;
    }

    private RestParamsPropertyHolder buildOverlay(RestResource resource) {
        return resource.getParentResource() == null ? resource.getParams() : new OverlayRestParamsPropertyHolder(this.buildOverlay(resource.getParentResource()), resource.getParams());
    }

    public RestResource getOperation() {
        return this.resource;
    }

    @Override
    public RestParamProperty addProperty(String name) {
        return this.params.addProperty(name);
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.params.moveProperty(propertyName, targetIndex);
    }

    @Override
    public RestParamProperty removeProperty(String propertyName) {
        return this.params.removeProperty(propertyName);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return this.params.renameProperty(name, newName);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.params.addTestPropertyListener(listener);
    }

    public RestParamsPropertyHolder getParams() {
        return this.params;
    }

    @Override
    public ModelItem getModelItem() {
        return this;
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.params.getProperties();
    }

    @Override
    public RestParamProperty getProperty(String name) {
        return this.params.getProperty(name);
    }

    @Override
    public RestParamProperty getPropertyAt(int index) {
        return this.params.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.params.getPropertyCount();
    }

    @Override
    public String[] getPropertyNames() {
        return this.params.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.params.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.params.hasProperty(name);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.params.removeTestPropertyListener(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.params.setPropertyValue(name, value);
    }

    @Override
    public String getPropertiesLabel() {
        return "Method Params";
    }

    public boolean hasRequestBody() {
        RestRequestInterface.HttpMethod method = this.getMethod();
        return method == RestRequestInterface.HttpMethod.POST || method == RestRequestInterface.HttpMethod.PUT || method == RestRequestInterface.HttpMethod.PATCH || method == RestRequestInterface.HttpMethod.DELETE;
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    public PropertyExpansion[] getPropertyExpansions() {
        return this.params.getPropertyExpansions();
    }

    public RestRequestInterface.HttpMethod getMethod() {
        String method = ((RestMethodConfig)this.getConfig()).getMethod();
        return method == null ? null : RestRequestInterface.HttpMethod.valueOf(method);
    }

    public void setMethod(RestRequestInterface.HttpMethod method) {
        RestRequestInterface.HttpMethod old = this.getMethod();
        ((RestMethodConfig)this.getConfig()).setMethod(method.toString());
        this.setIcon(UISupport.createImageIcon("/" + method.toString().toLowerCase() + "_method.gif"));
        this.notifyPropertyChanged("method", (Object)old, (Object)method);
    }

    public String getDefaultRequestMediaType() {
        RestRepresentation[] representations = this.getRepresentations(RestRepresentation.Type.REQUEST, null);
        if (representations.length >= 1) {
            return representations[0].getMediaType();
        }
        return "application/json";
    }

    public RestRepresentation[] getRepresentations() {
        return this.getRepresentations(null, null);
    }

    public RestRepresentation[] getRepresentations(RestRepresentation.Type type, String mediaType) {
        ArrayList<RestRepresentation> result = new ArrayList<RestRepresentation>();
        HashSet<String> addedTypes = new HashSet<String>();
        for (RestRepresentation representation : this.representations) {
            if (type != null && type != representation.getType() || mediaType != null && !mediaType.equals(representation.getMediaType())) continue;
            result.add(representation);
            addedTypes.add(representation.getMediaType());
        }
        if (type == RestRepresentation.Type.REQUEST) {
            for (RestRequest request : this.requests) {
                for (Attachment attachment : request.getAttachments()) {
                    if (mediaType != null && !mediaType.equals(attachment.getContentType()) || addedTypes.contains(attachment.getContentType())) continue;
                    RestRepresentation representation = new RestRepresentation(this, RestResourceRepresentationConfig.Factory.newInstance());
                    representation.setType(RestRepresentation.Type.REQUEST);
                    representation.setMediaType(attachment.getContentType());
                    result.add(representation);
                }
            }
        }
        return result.toArray(new RestRepresentation[result.size()]);
    }

    public String[] getResponseMediaTypes() {
        StringList result = new StringList();
        for (RestRepresentation representation : this.getRepresentations(RestRepresentation.Type.RESPONSE, null)) {
            if (result.contains(representation.getMediaType())) continue;
            result.add(representation.getMediaType());
        }
        return result.toStringArray();
    }

    public RestRepresentation addNewRepresentation(RestRepresentation.Type type) {
        RestRepresentation representation = new RestRepresentation(this, ((RestMethodConfig)this.getConfig()).addNewRepresentation());
        representation.setType(type);
        representation.addPropertyChangeListener(this.representationPropertyChangeListener);
        this.representations.add(representation);
        this.notifyPropertyChanged("representations", null, representation);
        return representation;
    }

    public void removeRepresentation(RestRepresentation representation) {
        int ix = this.representations.indexOf(representation);
        this.representations.remove(ix);
        representation.removePropertyChangeListener(this.representationPropertyChangeListener);
        this.notifyPropertyChanged("representations", representation, null);
        ((RestMethodConfig)this.getConfig()).removeRepresentation(ix);
        representation.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(RestRequest request) {
        int ix = this.requests.indexOf(request);
        this.requests.remove(ix);
        try {
            this.getInterface().fireRequestRemoved(request);
            this.notifyPropertyChanged("childRequests", request, null);
        }
        finally {
            request.release();
            ((RestMethodConfig)this.getConfig()).removeRequest(ix);
        }
    }

    public RestResource getResource() {
        return this.resource;
    }

    public List<RestRequest> getRequestList() {
        return new ArrayList<RestRequest>(this.requests);
    }

    public RestRequest getRequestAt(int index) {
        return this.requests.get(index);
    }

    public RestRequest getRequestByName(String name) {
        return (RestRequest)this.getWsdlModelItemByName(this.requests, name);
    }

    public int getRequestCount() {
        return this.requests.size();
    }

    public RestRequest addNewRequest(String name) {
        RestRequestConfig requestConfig = ((RestMethodConfig)this.getConfig()).addNewRequest();
        requestConfig.setName(name);
        RestRequest request = new RestRequest(this, requestConfig, false);
        this.requests.add(request);
        request.resetPropertyValues();
        String[] endpoints = this.getInterface().getEndpoints();
        if (endpoints.length > 0) {
            request.setEndpoint(endpoints[0]);
        }
        this.notifyPropertyChanged("childRequests", null, request);
        return request;
    }

    public RestRequest cloneRequest(RestRequest request, String name) {
        request.beforeSave();
        RestRequestConfig requestConfig = (RestRequestConfig)((RestMethodConfig)this.getConfig()).addNewRequest().set((XmlObject)request.getConfig());
        requestConfig.setName(name);
        RestRequest newRequest = new RestRequest(this, requestConfig, false);
        this.requests.add(newRequest);
        this.notifyPropertyChanged("childRequests", null, newRequest);
        return newRequest;
    }

    public RestParamProperty[] getDefaultParams() {
        ArrayList<RestParamProperty> result = new ArrayList<RestParamProperty>();
        HashSet<String> names = new HashSet<String>();
        result.addAll(Arrays.asList(this.resource.getDefaultParams()));
        for (int c = 0; c < this.getPropertyCount(); ++c) {
            if (names.contains(this.getPropertyAt(c).getName())) continue;
            result.add(this.getPropertyAt(c));
            names.add(this.getPropertyAt(c).getName());
        }
        return result.toArray(new RestParamProperty[result.size()]);
    }

    public RestService getInterface() {
        return this.resource.getInterface();
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getRequestList();
    }

    @Override
    public void release() {
        ((AbstractSoapUIDesktop)SoapUI.getDesktop()).closeDependantPanels(this);
        super.release();
        for (int i = this.requests.size(); i > 0; --i) {
            this.requests.get(i - 1).release();
        }
        this.getOperation().removePropertyChangeListener(this);
        this.params.release();
        this.removeTestPropertyListener(this.testPropertyListener);
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.params.getPropertyList();
    }

    private class InternalTestPropertyListener
    implements TestPropertyListener {
        private InternalTestPropertyListener() {
        }

        @Override
        public void propertyAdded(String name) {
        }

        @Override
        public void propertyMoved(String name, int oldIndex, int newIndex) {
        }

        @Override
        public void propertyRemoved(String name) {
        }

        @Override
        public void propertyRenamed(String oldName, String newName) {
        }

        @Override
        public void propertyValueChanged(String name, String oldValue, String newValue) {
            RestMethod.this.getProperty(name).setDefaultValue(newValue);
        }
    }

    private class RepresentationPropertyChangeListener
    implements PropertyChangeListener {
        private RepresentationPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("mediaType") && ((RestRepresentation)evt.getSource()).getType() == RestRepresentation.Type.RESPONSE) {
                RestMethod.this.notifyPropertyChanged("responseMediaTypes", null, RestMethod.this.getResponseMediaTypes());
            }
        }
    }
}

