/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.AnnotatedSettingsPrefs;
import com.eviware.soapui.actions.EditorPrefs;
import com.eviware.soapui.actions.GlobalPropertiesPrefs;
import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.actions.PrefsFactory;
import com.eviware.soapui.actions.ProxyPrefs;
import com.eviware.soapui.actions.SecurityScansPrefs;
import com.eviware.soapui.actions.ToolsPrefs;
import com.eviware.soapui.actions.UIPrefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.settings.SecuritySettings;
import com.eviware.soapui.settings.VersionUpdateSettings;
import com.eviware.soapui.settings.WSISettings;
import com.eviware.soapui.settings.WsaSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SwingConfigurationDialogImpl;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistryListener;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class SoapUIPreferencesAction
extends AbstractAction
implements SoapUIFactoryRegistryListener {
    public static final String GLOBAL_SECURITY_SETTINGS = "Global Security Settings";
    public static final String WS_I_SETTINGS = "WS-I Settings";
    public static final String WSDL_SETTINGS = "WSDL Settings";
    public static final String UI_SETTINGS = "UI Settings";
    public static final String EDITOR_SETTINGS = "Editor Settings";
    public static final String PROXY_SETTINGS = "Proxy Settings";
    public static final String HTTP_SETTINGS = "HTTP Settings";
    public static final String SSL_SETTINGS = "SSL Settings";
    public static final String INTEGRATED_TOOLS = "Tools";
    public static final String WSA_SETTINGS = "WS-A Settings";
    public static final String GLOBAL_SENSITIVE_INFORMATION_TOKENS = "Global Sensitive Information Tokens";
    public static final String VERSIONUPDATE_SETTINGS = "Version Update Settings";
    private SwingConfigurationDialogImpl dialog;
    private JTabbedPane tabs;
    private List<Prefs> prefs = new ArrayList<Prefs>();
    private Map<PrefsFactory, Prefs> prefsFactories = new HashMap<PrefsFactory, Prefs>();
    private static SoapUIPreferencesAction instance;

    public SoapUIPreferencesAction() {
        super("Preferences");
        this.putValue("ShortDescription", "Sets global SoapUI preferences");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt P"));
        this.putValue("SmallIcon", UISupport.createImageIcon("/preferences-system-small.png"));
        this.addPrefs(new AnnotatedSettingsPrefs(HttpSettings.class, HTTP_SETTINGS));
        this.addPrefs(new ProxyPrefs(PROXY_SETTINGS));
        this.addPrefs(new AnnotatedSettingsPrefs(SSLSettings.class, SSL_SETTINGS));
        this.addPrefs(new AnnotatedSettingsPrefs(WsdlSettings.class, WSDL_SETTINGS));
        this.addPrefs(new UIPrefs(UI_SETTINGS));
        this.addPrefs(new EditorPrefs(EDITOR_SETTINGS));
        this.addPrefs(new ToolsPrefs(INTEGRATED_TOOLS));
        this.addPrefs(new AnnotatedSettingsPrefs(WSISettings.class, WS_I_SETTINGS));
        this.addPrefs(new GlobalPropertiesPrefs());
        this.addPrefs(new AnnotatedSettingsPrefs(SecuritySettings.class, GLOBAL_SECURITY_SETTINGS));
        this.addPrefs(new AnnotatedSettingsPrefs(WsaSettings.class, WSA_SETTINGS));
        this.addPrefs(new SecurityScansPrefs(GLOBAL_SENSITIVE_INFORMATION_TOKENS));
        this.addPrefs(new AnnotatedSettingsPrefs(VersionUpdateSettings.class, VERSIONUPDATE_SETTINGS));
        for (PrefsFactory factory : SoapUI.getFactoryRegistry().getFactories(PrefsFactory.class)) {
            this.addPrefsFactory(factory);
        }
        SoapUI.getFactoryRegistry().addFactoryRegistryListener(this);
        instance = this;
    }

    public void addPrefsFactory(PrefsFactory factory) {
        Prefs pref = factory.createPrefs();
        this.addPrefs(pref);
        this.prefsFactories.put(factory, pref);
        if (this.tabs != null) {
            this.addPrefToTabs(pref);
        }
    }

    public void removePrefsFactory(PrefsFactory factory) {
        Prefs pref = this.prefsFactories.get(factory);
        if (pref != null) {
            int ix;
            this.prefsFactories.remove(factory);
            if (this.tabs != null && (ix = this.tabs.indexOfTab(pref.getTitle())) != -1) {
                this.tabs.removeTabAt(ix);
            }
            this.prefs.remove(pref);
        }
    }

    @Override
    public void factoryAdded(Class<?> factoryType, Object factory) {
        if (factoryType.equals(PrefsFactory.class)) {
            this.addPrefsFactory((PrefsFactory)factory);
        }
    }

    @Override
    public void factoryRemoved(Class<?> factoryType, Object factory) {
        if (factoryType.equals(PrefsFactory.class)) {
            this.removePrefsFactory((PrefsFactory)factory);
        }
    }

    public void addPrefs(Prefs pref) {
        this.prefs.add(pref);
    }

    public static SoapUIPreferencesAction getInstance() {
        if (instance == null) {
            instance = new SoapUIPreferencesAction();
        }
        return instance;
    }

    public Prefs[] getPrefs() {
        return this.prefs.toArray(new Prefs[this.prefs.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.show(HTTP_SETTINGS);
    }

    public boolean show(String initialTab) {
        int ix;
        if (this.dialog == null) {
            this.buildDialog();
        }
        Settings settings = SoapUI.getSettings();
        for (Prefs pref : this.prefs) {
            pref.setFormValues(settings);
        }
        if (initialTab != null && (ix = this.tabs.indexOfTab(initialTab)) != -1) {
            this.tabs.setSelectedIndex(ix);
        }
        if (this.dialog.show(new StringToStringMap())) {
            for (Prefs pref : this.prefs) {
                pref.getFormValues(settings);
            }
            return true;
        }
        return false;
    }

    private void buildDialog() {
        this.dialog = new SwingConfigurationDialogImpl("SoapUI Preferences", "http://www.soapui.org/Working-with-soapUI/preferences.html", "Set global SoapUI settings", UISupport.OPTIONS_ICON);
        this.tabs = new JTabbedPane();
        this.tabs.setTabLayoutPolicy(1);
        this.tabs.setTabPlacement(2);
        for (Prefs pref : this.prefs) {
            this.addPrefToTabs(pref);
        }
        this.dialog.setContent(UISupport.createTabPanel(this.tabs, false));
    }

    private void addPrefToTabs(Prefs pref) {
        this.tabs.addTab(pref.getTitle(), new JScrollPane(pref.getForm().getPanel()));
    }
}

