/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.tools.MockAsWar;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.validators.RequiredValidator;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MockAsWarAction
extends AbstractSoapUIAction<WsdlProject> {
    private XFormDialog dialog;
    private Logger log = Logger.getLogger(MockAsWarAction.class);

    public MockAsWarAction() {
        super("Deploy As War", "Deploys Project MockServices as a WAR file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(WsdlProject project, Object param) {
        if (project.getMockServiceCount() + project.getRestMockServiceCount() == 0) {
            UISupport.showErrorMessage("Project does not have any MockServices to deploy");
            return;
        }
        if (this.dialog == null) {
            this.buildDialog();
        }
        XFormField settingFile = this.getPreFilledSettings();
        XFormField warFile = this.dialog.getFormField("War File");
        String passwordForEncryption = project.getSettings().getString(ProjectSettings.SHADOW_PASSWORD, null);
        project.getSettings().setString(ProjectSettings.SHADOW_PASSWORD, null);
        if (this.dialog.show()) {
            project.beforeSave();
            try {
                project.save();
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                project.getSettings().setString(ProjectSettings.SHADOW_PASSWORD, passwordForEncryption);
            }
            MockAsWar mockAsWar = new MockAsWar(project.getPath(), this.dialog.getBooleanValue("Include Global Settings") ? settingFile.getValue() : "", this.dialog.getFormField("War Directory").getValue(), this.dialog.getFormField("War File").getValue(), this.dialog.getBooleanValue("Include External Jar Files"), this.dialog.getBooleanValue("Include Actions"), this.dialog.getBooleanValue("Include Listeners"), this.dialog.getValue("MockService Endpoint"), this.dialog.getBooleanValue("WebUI"), project);
            mockAsWar.createMockAsWarArchive();
            if (project.getRestMockServiceCount() > 0) {
                Analytics.trackAction((String)SoapUIActions.DEPLOY_REST_MOCK_AS_WAR.getActionName());
            }
            if (project.getMockServiceCount() > 0) {
                Analytics.trackAction((String)SoapUIActions.DEPLOY_SOAP_MOCK_AS_WAR.getActionName());
            }
        }
    }

    protected void setDialog(XFormDialog dialog) {
        this.dialog = dialog;
    }

    private XFormField getPreFilledSettings() {
        XFormField settingFile = this.dialog.getFormField("Settings");
        DefaultSoapUICore soapUICore = (DefaultSoapUICore)SoapUI.getSoapUICore();
        settingFile.setValue(soapUICore.getSettingsFile());
        settingFile.setEnabled(this.dialog.getBooleanValue("Include Global Settings"));
        return settingFile;
    }

    private void buildDialog() {
        this.dialog = ADialogBuilder.buildDialog(MockAsWarDialog.class);
        this.dialog.getFormField("Include Global Settings").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MockAsWarAction.this.dialog.getFormField("Settings").setEnabled(Boolean.valueOf(newValue));
            }
        });
        this.dialog.getFormField("War Directory").addFormFieldValidator(new RequiredValidator("WAR Directory is required"));
    }

    @AForm(description="Configure what to include in generated WAR", name="Deploy Project as WAR", helpUrl="http://www.soapui.org/Service-Mocking/deploying-mock-services-as-war-files.html")
    protected static interface MockAsWarDialog {
        @AField(description="Specify if global settings should be included", name="Include Global Settings", type=AField.AFieldType.BOOLEAN)
        public static final String GLOBAL_SETTINGS = "Include Global Settings";
        @AField(description="Specify Settings File", name="Settings", type=AField.AFieldType.FILE)
        public static final String SETTINGS_FILE = "Settings";
        @AField(description="Specify if action extensions should be included", name="Include Actions", type=AField.AFieldType.BOOLEAN)
        public static final String ACTIONS = "Include Actions";
        @AField(description="Specify if listener extensions should be included", name="Include Listeners", type=AField.AFieldType.BOOLEAN)
        public static final String LISTENERS = "Include Listeners";
        @AField(description="Include jar files from ext folder", name="Include External Jar Files", type=AField.AFieldType.BOOLEAN)
        public static final String EXT_LIBS = "Include External Jar Files";
        @AField(description="Check to enable WebUI", name="WebUI", type=AField.AFieldType.BOOLEAN)
        public static final String ENABLE_WEBUI = "WebUI";
        @AField(description="Local endpoint that will be used for WSDL endpoints/includes/imports", name="MockService Endpoint", type=AField.AFieldType.STRING)
        public static final String MOCKSERVICE_ENDPOINT = "MockService Endpoint";
        @AField(description="Specify name of target War File", name="War File", type=AField.AFieldType.FILE)
        public static final String WAR_FILE = "War File";
        @AField(description="Specify a directory where War file structure will be created", name="War Directory", type=AField.AFieldType.FOLDER)
        public static final String WAR_DIRECTORY = "War Directory";
    }
}

