/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.Setting;
import com.eviware.soapui.support.components.DirectoryFormComponent;
import com.eviware.soapui.support.components.FileFormComponent;
import com.eviware.soapui.support.components.FileListFormComponent;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.components.StringListFormComponent;
import com.eviware.soapui.support.types.StringToStringMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class AnnotatedSettingsPrefs
implements Prefs {
    private SimpleForm simpleForm;
    private Class<?> settingsClass;
    private final String title;

    public AnnotatedSettingsPrefs(Class<?> settingsClass, String title) {
        this.settingsClass = settingsClass;
        this.title = title;
    }

    @Override
    public SimpleForm getForm() {
        if (this.simpleForm == null) {
            this.simpleForm = new SimpleForm();
            this.simpleForm.addSpace(5);
            this.buildForm(this.simpleForm);
            this.simpleForm.addSpace(5);
        }
        return this.simpleForm;
    }

    public List<Setting> getSettings() {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        for (Field field : this.settingsClass.getFields()) {
            Setting annotation = field.getAnnotation(Setting.class);
            if (annotation == null) continue;
            settings.add(annotation);
        }
        return settings;
    }

    private void buildForm(SimpleForm form) {
        List<Setting> settings = this.getSettings();
        block9: for (Setting annotation : settings) {
            switch (annotation.type()) {
                case BOOLEAN: {
                    form.appendCheckBox(annotation.name(), annotation.description(), false);
                    continue block9;
                }
                case FILE: {
                    form.append(annotation.name(), new FileFormComponent(annotation.description()));
                    continue block9;
                }
                case FILELIST: {
                    form.append(annotation.name(), new FileListFormComponent(annotation.description()));
                    continue block9;
                }
                case STRINGLIST: {
                    form.append(annotation.name(), new StringListFormComponent(annotation.description()));
                    continue block9;
                }
                case FOLDER: {
                    form.append(annotation.name(), new DirectoryFormComponent(annotation.description()));
                    continue block9;
                }
                case ENUMERATION: {
                    form.appendComboBox(annotation.name(), annotation.values(), annotation.description());
                    continue block9;
                }
                case PASSWORD: {
                    form.appendPasswordField(annotation.name(), annotation.description());
                    continue block9;
                }
            }
            form.appendTextField(annotation.name(), annotation.description());
        }
    }

    @Override
    public StringToStringMap getValues(Settings settings) {
        StringToStringMap result = new StringToStringMap();
        for (Field field : this.settingsClass.getFields()) {
            Setting annotation = field.getAnnotation(Setting.class);
            if (annotation == null) continue;
            try {
                result.put(annotation.name(), settings.getString(field.get(null).toString(), annotation.defaultValue()));
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return result;
    }

    @Override
    public void setFormValues(Settings settings) {
        this.getForm().setValues(this.getValues(settings));
    }

    @Override
    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        this.getForm().getValues(values);
        this.storeValues(values, settings);
    }

    @Override
    public void storeValues(StringToStringMap values, Settings settings) {
        for (Field field : this.settingsClass.getFields()) {
            Setting annotation = field.getAnnotation(Setting.class);
            if (annotation == null) continue;
            try {
                settings.setString(field.get(null).toString(), (String)values.get(annotation.name()));
            }
            catch (IllegalArgumentException e) {
                SoapUI.logError(e);
            }
            catch (IllegalAccessException e) {
                SoapUI.logError(e);
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

