/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.wsAddressingSpoofing.option;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.composition.plugin.option.AbstractOptionVarchar;
import wsattacker.main.plugin.option.OptionSimpleChoice;

public class OptionIpChooser
extends OptionSimpleChoice {
    private static final String URL = "http://showip.net";
    public static final String AUTO = String.format("Detect your IP via %s", "http://showip.net");
    public static final String MANUAL = "Edit settings below as you like";
    private static final String REGEX = "[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}";
    private static final Pattern PATTERN = Pattern.compile("[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}");
    private static final Logger LOG = Logger.getLogger(OptionIpChooser.class);
    private static final long serialVersionUID = 2L;
    private final AbstractOptionVarchar url;
    private final AbstractOptionInteger port;
    private HttpClient httpClient;

    public OptionIpChooser(String name, String description, AbstractOptionVarchar url, AbstractOptionInteger port) {
        this(name, description, url, port, new HttpClient());
    }

    protected OptionIpChooser(String name, String description, AbstractOptionVarchar url, AbstractOptionInteger port, HttpClient httpClient) {
        super(name, description);
        this.httpClient = httpClient;
        ArrayList<String> choices = new ArrayList<String>();
        choices.add(MANUAL);
        choices.add(AUTO);
        this.setChoices(choices);
        this.url = url;
        this.port = port;
        this.setSelectedAsString(AUTO);
    }

    public void setSelectedAsString(String selected) {
        super.setSelectedAsString(selected);
        if (AUTO.equals(selected)) {
            this.updateUrl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String detectIP() {
        String html;
        String ip = null;
        GetMethod method = new GetMethod(URL);
        try {
            int statusCode = this.httpClient.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                LOG.error((Object)"Could not fetch website to detect IP");
                String string = null;
                return string;
            }
            byte[] responseBody = method.getResponseBody();
            html = new String(responseBody);
        }
        catch (HttpException e) {
            LOG.error((Object)"Could not fetch website to detect IP");
            String string = null;
            return string;
        }
        catch (IOException e) {
            LOG.error((Object)"Could not fetch website to detect IP");
            String string = null;
            return string;
        }
        finally {
            method.releaseConnection();
        }
        Matcher m = PATTERN.matcher(html);
        m.find();
        ip = html.substring(m.start(), m.end());
        return ip;
    }

    private void updateUrl() {
        String ip = this.detectIP();
        if (ip == null) {
            this.url.setValue("Could not detect your IP");
        } else {
            this.url.setValue("http://" + ip + ":" + this.port.getValue());
        }
        this.setSelectedAsString(MANUAL);
    }
}

