/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlInput
extends HtmlElement
implements DisabledElement,
SubmittableElement {
    private static final long serialVersionUID = 3602129443357463947L;
    public static final String TAG_NAME = "input";
    private String defaultValue_ = this.getValueAttribute();

    public HtmlInput(SgmlPage page, Map<String, DomAttr> attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    public HtmlInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public Page setValueAttribute(String newValue) {
        WebAssert.notNull("newValue", newValue);
        this.setAttribute("value", newValue);
        return HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getValueAttribute() {
        return this.getAttribute("value");
    }

    public final String getCheckedAttribute() {
        return this.getAttribute("checked");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttribute("readonly");
    }

    public final String getSizeAttribute() {
        return this.getAttribute("size");
    }

    public final String getMaxLengthAttribute() {
        return this.getAttribute("maxlength");
    }

    public final String getSrcAttribute() {
        return this.getAttribute("src");
    }

    public final String getAltAttribute() {
        return this.getAttribute("alt");
    }

    public final String getUseMapAttribute() {
        return this.getAttribute("usemap");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttribute("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttribute("onchange");
    }

    public final String getAcceptAttribute() {
        return this.getAttribute("accept");
    }

    public final String getAlignAttribute() {
        return this.getAttribute("align");
    }

    @Override
    public void reset() {
        this.setValueAttribute(this.defaultValue_);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.getPage().getWebClient().getBrowserVersion().isFirefox();
        this.setDefaultValue(defaultValue, modifyValue);
    }

    protected void setDefaultValue(String defaultValue, boolean modifyValue) {
        this.defaultValue_ = defaultValue;
        if (modifyValue) {
            this.setValueAttribute(defaultValue);
        }
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue_;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public Page setChecked(boolean isChecked) {
        return this.getPage();
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.setAttribute("readOnly", "readOnly");
        } else {
            this.removeAttribute("readOnly");
        }
    }

    public boolean isChecked() {
        return this.hasAttribute("checked");
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    public <P extends Page> P click(int x, int y) throws IOException, ElementNotFoundException {
        return this.click();
    }

    static Page executeOnChangeHandlerIfAppropriate(HtmlElement htmlElement) {
        SgmlPage page = htmlElement.getPage();
        JavaScriptEngine engine = htmlElement.getPage().getWebClient().getJavaScriptEngine();
        if (engine.isScriptRunning()) {
            return page;
        }
        ScriptResult scriptResult = htmlElement.fireEvent("change");
        if (page.getWebClient().getWebWindows().contains(page.getEnclosingWindow())) {
            return page.getEnclosingWindow().getEnclosedPage();
        }
        if (scriptResult != null) {
            return scriptResult.getNewPage();
        }
        return page;
    }
}

