/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption;

import java.util.ArrayList;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.AbstractEncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.signature.RetrievalMethod;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRetrievalMethodEncryptedKeyResolver
extends AbstractEncryptedKeyResolver {
    private final Logger log = LoggerFactory.getLogger(SimpleRetrievalMethodEncryptedKeyResolver.class);

    @Override
    public Iterable<EncryptedKey> resolve(EncryptedData encryptedData) {
        ArrayList<EncryptedKey> resolvedEncKeys = new ArrayList<EncryptedKey>();
        if (encryptedData.getKeyInfo() == null) {
            return resolvedEncKeys;
        }
        for (RetrievalMethod rm : encryptedData.getKeyInfo().getRetrievalMethods()) {
            if (!DatatypeHelper.safeEquals(rm.getType(), "http://www.w3.org/2001/04/xmlenc#EncryptedKey")) continue;
            if (rm.getTransforms() != null) {
                this.log.warn("EncryptedKey RetrievalMethod has transforms, can not process");
                continue;
            }
            EncryptedKey encKey = this.dereferenceURI(rm);
            if (encKey == null || !this.matchRecipient(encKey.getRecipient())) continue;
            resolvedEncKeys.add(encKey);
        }
        return resolvedEncKeys;
    }

    protected EncryptedKey dereferenceURI(RetrievalMethod rm) {
        String uri = rm.getURI();
        if (DatatypeHelper.isEmpty(uri) || !uri.startsWith("#")) {
            this.log.warn("EncryptedKey RetrievalMethod did not contain a same-document URI reference, can not process");
            return null;
        }
        XMLObject target = rm.resolveIDFromRoot(uri.substring(1));
        if (target == null) {
            this.log.warn("EncryptedKey RetrievalMethod URI could not be dereferenced");
            return null;
        }
        if (!(target instanceof EncryptedKey)) {
            this.log.warn("The product of dereferencing the EncryptedKey RetrievalMethod was not an EncryptedKey");
            return null;
        }
        return (EncryptedKey)target;
    }
}

