/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Candidates;
import uk.ac.shef.wit.simmetrics.similaritymetrics.TagLinkToken;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserWhitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TagLink
extends AbstractStringMetric
implements Serializable {
    private HashMap<String, Float> idfMap;
    private AbstractStringMetric characterBasedStringMetric;
    private static final AbstractStringMetric DEFAULT_METRIC = new TagLinkToken();
    private final InterfaceTokeniser tokeniser;
    private final float ESTIMATEDTIMINGCONST = 6.186371E-4f;

    public TagLink() {
        this(DEFAULT_METRIC);
        System.out.println("WARNING - this metric is not recomended for fast processing it has been added \n by a third party into the library and from the source is an extremely \n unoptermised process the library author does not recomend its usage \n if you do take the time to perfect this code I will gladly update its\n source - thanks Sam");
    }

    public TagLink(AbstractStringMetric characterBasedStringMetric) {
        this.characterBasedStringMetric = characterBasedStringMetric;
        this.tokeniser = new TokeniserWhitespace();
        System.out.println("WARNING - this metric is not recomended for fast processing it has been added \n by a third party into the library and from the source is an extremely \n unoptermised process the library author does not recomend its usage \n if you do take the time to perfect this code I will gladly update its\n source - thanks Sam");
    }

    public TagLink(String[] dataSetArray) {
        this(dataSetArray, DEFAULT_METRIC);
        System.out.println("WARNING - this metric is not recomended for fast processing it has been added \n by a third party into the library and from the source is an extremely \n unoptermised process the library author does not recomend its usage \n if you do take the time to perfect this code I will gladly update its\n source - thanks Sam");
    }

    public TagLink(String[] dataSetArray, AbstractStringMetric characterBasedStringMetric) {
        this.characterBasedStringMetric = characterBasedStringMetric;
        this.tokeniser = new TokeniserWhitespace();
        this.idfMap = this.getIDFMap(dataSetArray);
        System.out.println("WARNING - this metric is not recomended for fast processing it has been added \n by a third party into the library and from the source is an extremely \n unoptermised process the library author does not recomend its usage \n if you do take the time to perfect this code I will gladly update its\n source - thanks Sam");
    }

    private float getMinStringSize(String[] tTokens, String[] uTokens) {
        float tSize = 0.0f;
        float uSize = 0.0f;
        for (String tToken : tTokens) {
            tSize += (float)tToken.length();
        }
        for (String uToken : uTokens) {
            uSize += (float)uToken.length();
        }
        return Math.min(tSize, uSize);
    }

    @Override
    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return str1Length * str2Length * 6.186371E-4f;
    }

    @Override
    public float getUnNormalisedSimilarity(String T, String U) {
        return this.getSimilarity(T, U);
    }

    @Override
    public float getSimilarity(String T, String U) {
        System.out.println("WARNING - this metric is not recomended for fast processing it has been added \n by a third party into the library and from the source is an extremely \n unoptermised process the library author does not recomend its usage \n if you do take the time to perfect this code I will gladly update its\n source - thanks Sam");
        if (T.equals(U)) {
            return 1.0f;
        }
        ArrayList<String> tArrayList = this.tokeniser.tokenizeToArrayList(T);
        ArrayList<String> uArrayList = this.tokeniser.tokenizeToArrayList(U);
        String[] tTokens = tArrayList.toArray(new String[tArrayList.size()]);
        String[] uTokens = uArrayList.toArray(new String[uArrayList.size()]);
        float[] tIdfArray = this.getIDFArray(tTokens);
        float[] uIdfArray = this.getIDFArray(uTokens);
        return this.algorithm1(tTokens, uTokens, tIdfArray, uIdfArray);
    }

    private float algorithm1(String[] tTokens, String[] uTokens, float[] tIdfArray, float[] uIdfArray) {
        ArrayList<Candidates> candidateList = this.obtainCandidateList(tTokens, uTokens, tIdfArray, uIdfArray);
        this.sortCandidateList(candidateList);
        float scoreValue = 0.0f;
        HashMap tMap = new HashMap();
        HashMap uMap = new HashMap();
        Iterator<Candidates> i$ = candidateList.iterator();
        while (i$.hasNext()) {
            Candidates aCandidateList;
            Candidates actualCandidates = aCandidateList = i$.next();
            Integer tPos = actualCandidates.getTPos();
            Integer uPos = actualCandidates.getUPos();
            if (tMap.containsKey(tPos) || uMap.containsKey(uPos)) continue;
            scoreValue += actualCandidates.getScore();
            tMap.put(tPos, null);
            uMap.put(uPos, null);
        }
        return scoreValue;
    }

    @Override
    public String getSimilarityExplained(String T, String U) {
        StringBuffer buff = new StringBuffer();
        buff.append("\n\t*****TagLink String Distance*****");
        if (T.equals(U)) {
            buff.append("\nS(T,U)=1.0\n");
        } else {
            int i;
            ArrayList<String> tArrayList = this.tokeniser.tokenizeToArrayList(T);
            ArrayList<String> uArrayList = this.tokeniser.tokenizeToArrayList(U);
            String[] tTokens = tArrayList.toArray(new String[tArrayList.size()]);
            String[] uTokens = uArrayList.toArray(new String[uArrayList.size()]);
            buff.append("\nT={");
            for (String tToken : tTokens) {
                buff.append(tToken).append(", ");
            }
            buff.append("}\n");
            buff.append("U={");
            for (String uToken : uTokens) {
                buff.append(uToken).append(", ");
            }
            buff.append("}\n");
            float minStringSize = this.getMinStringSize(tTokens, uTokens);
            buff.append("min(|T|,|U|)=").append(minStringSize).append("\n");
            buff.append("\nIDF weights:\n");
            buff.append("Ti\tai(Ti)\n");
            float[] tIdfArray = this.getIDFArray(tTokens);
            float[] uIdfArray = this.getIDFArray(uTokens);
            for (i = 0; i < tIdfArray.length; ++i) {
                buff.append(tTokens[i]).append("\t").append(this.round(tIdfArray[i])).append("\n");
            }
            buff.append("\nUj\taj(Uj)\n");
            for (i = 0; i < uIdfArray.length; ++i) {
                buff.append(uTokens[i]).append("\t").append(this.round(uIdfArray[i])).append("\n");
            }
            buff.append("\nScores:\n");
            buff.append("Ti\tUj\tSij(Ti,Uj)\tIDFij(Ti,Uj)\tMRij(Ti,Uj)\tSij\n");
            ArrayList<Candidates> candidateList = new ArrayList<Candidates>();
            for (int t = 0; t < tTokens.length; ++t) {
                int lastTr = -1;
                boolean flag = false;
                for (int u = 0; u < uTokens.length && !flag; ++u) {
                    int tr = Math.abs(t - u);
                    if (lastTr >= 0 && lastTr < tr) {
                        flag = true;
                        continue;
                    }
                    String tTok = tTokens[t];
                    String uTok = uTokens[u];
                    float innerScore = this.characterBasedStringMetric.getSimilarity(tTok, uTok);
                    if (!((double)innerScore >= 0.0)) continue;
                    float MR = (double)innerScore == 1.0 ? (float)tTokens[t].length() : ((TagLinkToken)this.characterBasedStringMetric).getMatched();
                    float IDF = tIdfArray[t] * uIdfArray[u];
                    float weight = (IDF + (MR /= minStringSize)) / 2.0f;
                    if (innerScore == 1.0f) {
                        lastTr = tr;
                    }
                    buff.append(tTok).append("\t").append(uTok).append("\t").append(this.round(innerScore)).append("\t").append(this.round(IDF)).append("\t").append(this.round(MR)).append("\t").append(this.round(innerScore * weight)).append("\n");
                    candidateList.add(new Candidates(t, u, innerScore * weight));
                }
            }
            this.sortCandidateList(candidateList);
            buff.append("\nCommon tokens (Algorithm 1):\n");
            buff.append("Ti\tUj\tSij*Xij\n");
            float score = 0.0f;
            HashMap tMap = new HashMap();
            HashMap uMap = new HashMap();
            Iterator<Candidates> i$ = candidateList.iterator();
            while (i$.hasNext()) {
                Candidates aCandidateList;
                Candidates actualCandidates = aCandidateList = i$.next();
                Integer tPos = actualCandidates.getTPos();
                Integer uPos = actualCandidates.getUPos();
                if (tMap.containsKey(tPos) || uMap.containsKey(uPos)) continue;
                float tokenScore = actualCandidates.getScore();
                score += tokenScore;
                tMap.put(tPos, null);
                uMap.put(uPos, null);
                buff.append(tTokens[tPos]).append("\t").append(uTokens[uPos]).append("\t").append(this.round(tokenScore)).append("\n");
            }
            buff.append("\nS(T,U)=").append(this.round(score)).append("\n");
        }
        return buff.toString();
    }

    private ArrayList<Candidates> obtainCandidateList(String[] tTokens, String[] uTokens, float[] tIdfArray, float[] uIdfArray) {
        ArrayList<Candidates> candidateList = new ArrayList<Candidates>();
        float minStringSize = this.getMinStringSize(tTokens, uTokens);
        for (int t = 0; t < tTokens.length; ++t) {
            int lastTr = -1;
            boolean flag = false;
            for (int u = 0; u < uTokens.length && !flag; ++u) {
                int tr = Math.abs(t - u);
                if (lastTr >= 0 && lastTr < tr) {
                    flag = true;
                    continue;
                }
                String tTok = tTokens[t];
                String uTok = uTokens[u];
                float innerScore = this.characterBasedStringMetric.getSimilarity(tTok, uTok);
                if (!(innerScore >= 0.0f)) continue;
                float matched = innerScore == 1.0f ? (float)tTokens[t].length() : ((TagLinkToken)this.characterBasedStringMetric).getMatched();
                float weightMatched = matched / minStringSize;
                float weightTFIDF = tIdfArray[t] * uIdfArray[u];
                float weight = (weightTFIDF + weightMatched) / 2.0f;
                if (innerScore == 1.0f) {
                    lastTr = tr;
                }
                candidateList.add(new Candidates(t, u, innerScore * weight));
            }
        }
        return candidateList;
    }

    private void sortCandidateList(ArrayList<Candidates> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                float scoreT = ((Candidates)o1).getScore();
                float scoreU = ((Candidates)o2).getScore();
                if (scoreU > scoreT) {
                    return 1;
                }
                if (scoreU < scoreT) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private float[] getIDFArray(String[] tokenArray) {
        int tokenArrayLength = tokenArray.length;
        float[] IDFArray = new float[tokenArrayLength];
        if (this.idfMap == null) {
            float cosineWeight = 1.0f / (float)Math.sqrt(tokenArrayLength);
            for (int i = 0; i < tokenArrayLength; ++i) {
                IDFArray[i] = cosineWeight;
            }
        } else {
            int i;
            float sq = 0.0f;
            for (i = 0; i < tokenArrayLength; ++i) {
                String actualToken = tokenArray[i];
                float idfWeight = 0.0f;
                try {
                    idfWeight = this.idfMap.get(actualToken).floatValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                IDFArray[i] = idfWeight;
                sq += idfWeight * idfWeight;
            }
            sq = (float)Math.sqrt(sq);
            for (i = 0; i < tokenArrayLength; ++i) {
                IDFArray[i] = IDFArray[i] / sq;
            }
        }
        return IDFArray;
    }

    @Override
    public String getLongDescriptionString() {
        return this.getShortDescriptionString();
    }

    @Override
    public String getShortDescriptionString() {
        if (this.idfMap == null) {
            return "[TagLink_[" + this.characterBasedStringMetric.toString() + "]";
        }
        return "[TagLink_IDF_[" + this.characterBasedStringMetric.toString() + "]";
    }

    private HashMap<String, Float> getIDFMap(String[] dataSetArray) {
        float N = dataSetArray.length;
        HashMap<String, Float> idfMap = new HashMap<String, Float>();
        int row = 0;
        while ((float)row < N) {
            String[] rowArray;
            HashMap rowMap = new HashMap();
            HashMap<String, Float> freqMap = new HashMap<String, Float>();
            String actualRow = dataSetArray[row];
            ArrayList<String> tokenArrayList = this.tokeniser.tokenizeToArrayList(actualRow);
            for (String actualToken : rowArray = tokenArrayList.toArray(new String[tokenArrayList.size()])) {
                rowMap.put(actualToken, null);
                float actualFrequency = this.getFrequency(actualToken, freqMap) + 1.0f;
                freqMap.put(actualToken, Float.valueOf(actualFrequency));
            }
            Set entries = rowMap.keySet();
            for (String actualToken : entries) {
                float actualFrequency = this.getFrequency(actualToken, idfMap) + 1.0f;
                idfMap.put(actualToken, Float.valueOf(actualFrequency));
            }
            ++row;
        }
        Set entries = idfMap.entrySet();
        Iterator i$ = entries.iterator();
        while (i$.hasNext()) {
            Map.Entry entry;
            Map.Entry ent = entry = (Map.Entry)i$.next();
            String key = (String)ent.getKey();
            float frequency = ((Float)ent.getValue()).floatValue();
            float idf = (float)Math.log(N / frequency + 1.0f);
            idfMap.put(key, Float.valueOf(idf));
        }
        return idfMap;
    }

    private float getFrequency(String word, Map<String, Float> map) {
        Float frequency = map.get(word);
        if (frequency == null) {
            return 0.0f;
        }
        return frequency.floatValue();
    }

    private float round(float number) {
        int round = (int)(number * 1000.0f);
        float rest = number * 1000.0f - (float)round;
        if (rest >= 0.5f) {
            ++round;
        }
        return (float)round / 1000.0f;
    }
}

