/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.SmithWaterman;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Soundex;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserWhitespace;

public final class ChapmanOrderedNameCompoundSimilarity
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 0.026571428f;
    final InterfaceTokeniser tokeniser;
    private final AbstractStringMetric internalStringMetric1 = new Soundex();
    private final AbstractStringMetric internalStringMetric2 = new SmithWaterman();

    public ChapmanOrderedNameCompoundSimilarity() {
        this.tokeniser = new TokeniserWhitespace();
    }

    public ChapmanOrderedNameCompoundSimilarity(InterfaceTokeniser tokeniserToUse) {
        this.tokeniser = tokeniserToUse;
    }

    public String getShortDescriptionString() {
        return "ChapmanOrderedNameCompoundSimilarity";
    }

    public String getLongDescriptionString() {
        return "Implements the Chapman Ordered Name Compound Similarity algorithm whereby terms are matched and tested against the standard soundex algorithm - this is intended to provide a better rating for lists of proper names.";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Tokens = this.tokeniser.tokenizeToArrayList(string1).size();
        float str2Tokens = this.tokeniser.tokenizeToArrayList(string2).size();
        return (float)(this.tokeniser.tokenizeToArrayList(string1).size() + this.tokeniser.tokenizeToArrayList(string2).size()) * ((str1Tokens + str2Tokens) * 0.026571428f);
    }

    public final float getSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        int str1TokenNum = str1Tokens.size();
        int str2TokenNum = str2Tokens.size();
        int minTokens = Math.min(str1TokenNum, str2TokenNum);
        float SKEW_AMMOUNT = 1.0f;
        float sumMatches = 0.0f;
        for (int i = 1; i <= minTokens; ++i) {
            float strWeightingAdjustment = 1.0f / (float)minTokens + ((float)(minTokens - i) + 0.5f - (float)minTokens / 2.0f) / (float)minTokens * SKEW_AMMOUNT * (1.0f / (float)minTokens);
            String sToken = str1Tokens.get(str1TokenNum - i);
            String tToken = str2Tokens.get(str2TokenNum - i);
            float found1 = this.internalStringMetric1.getSimilarity(sToken, tToken);
            float found2 = this.internalStringMetric2.getSimilarity(sToken, tToken);
            sumMatches += 0.5f * (found1 + found2) * strWeightingAdjustment;
        }
        return sumMatches;
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        return this.getSimilarity(string1, string2);
    }
}

