/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends FlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;
    VariableBinding[] nullVariables;
    Expression[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;

    public FinallyFlowContext(FlowContext parent, ASTNode associatedNode) {
        super(parent, associatedNode);
    }

    public void complainOnDeferredChecks(FlowInfo flowInfo, BlockScope scope) {
        int i = 0;
        while (i < this.assignCount) {
            VariableBinding variable = this.finalVariables[i];
            if (variable != null) {
                boolean complained = false;
                if (variable instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned(variable)) {
                        complained = true;
                        scope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variable, this.finalAssignments[i]);
                    }
                } else if (flowInfo.isPotentiallyAssigned(variable)) {
                    complained = true;
                    scope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variable, this.finalAssignments[i]);
                }
                if (complained) {
                    FlowContext currentContext = this.getLocalParent();
                    while (currentContext != null) {
                        currentContext.removeFinalAssignmentIfAny(this.finalAssignments[i]);
                        currentContext = currentContext.getLocalParent();
                    }
                }
            }
            ++i;
        }
        if ((this.tagBits & 1) != 0) {
            i = 0;
            while (i < this.nullCount) {
                if (this.nullCheckTypes[i] == 128) {
                    this.parent.recordNullityMismatch(scope, this.nullReferences[i], flowInfo.nullStatus(this.nullVariables[i]), this.expectedTypes[i]);
                } else {
                    this.parent.recordUsingNullReference(scope, this.nullVariables[i], this.nullReferences[i], this.nullCheckTypes[i], flowInfo);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nullCount) {
                Expression expression = this.nullReferences[i];
                VariableBinding var = this.nullVariables[i];
                block0 : switch (this.nullCheckTypes[i]) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(var)) {
                            if (this.nullCheckTypes[i] == 512) {
                                if ((this.tagBits & 4) != 0) break;
                                scope.problemReporter().variableRedundantCheckOnNonNull(var, expression);
                                break;
                            }
                            if ((this.tagBits & 4) != 0) break;
                            scope.problemReporter().variableNonNullComparedToNull(var, expression);
                            break;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        if (flowInfo.isDefinitelyNull(var)) {
                            switch (this.nullCheckTypes[i] & 0xFFFFFF00) {
                                case 256: {
                                    if ((this.nullCheckTypes[i] & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().variableNullReference(var, expression);
                                        break block0;
                                    }
                                    if ((this.tagBits & 4) != 0) break block0;
                                    scope.problemReporter().variableRedundantCheckOnNull(var, expression);
                                    break block0;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[i] & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().variableNullReference(var, expression);
                                        break block0;
                                    }
                                    if ((this.tagBits & 4) != 0) break block0;
                                    scope.problemReporter().variableNullComparedToNonNull(var, expression);
                                    break block0;
                                }
                                case 768: {
                                    scope.problemReporter().variableRedundantNullAssignment(var, expression);
                                    break block0;
                                }
                                case 1024: {
                                    scope.problemReporter().variableNullInstanceof(var, expression);
                                    break block0;
                                }
                            }
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(var)) break;
                        switch (this.nullCheckTypes[i] & 0xFFFFFF00) {
                            case 256: {
                                this.nullReferences[i] = null;
                                if ((this.nullCheckTypes[i] & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break block0;
                                scope.problemReporter().variablePotentialNullReference(var, expression);
                                break block0;
                            }
                            case 512: {
                                this.nullReferences[i] = null;
                                if ((this.nullCheckTypes[i] & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break block0;
                                scope.problemReporter().variablePotentialNullReference(var, expression);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(var)) {
                            scope.problemReporter().variableNullReference(var, expression);
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(var)) break;
                        scope.problemReporter().variablePotentialNullReference(var, expression);
                        break;
                    }
                    case 128: {
                        int nullStatus = flowInfo.nullStatus(var);
                        if (nullStatus == 4) break;
                        char[][] annotationName = scope.environment().getNonNullAnnotationName();
                        scope.problemReporter().nullityMismatch(expression, this.expectedTypes[i], nullStatus, annotationName);
                    }
                }
                ++i;
            }
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Finally flow context");
        buffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        buffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return buffer.toString();
    }

    public boolean isSubRoutine() {
        return true;
    }

    protected boolean recordFinalAssignment(VariableBinding binding, Reference finalAssignment) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = finalAssignment;
        this.finalVariables[this.assignCount++] = binding;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recordUsingNullReference(Scope scope, VariableBinding var, Expression reference, int checkType, FlowInfo flowInfo) {
        block56: {
            block55: {
                if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(var)) return;
                if ((this.tagBits & 1) == 0) break block55;
                switch (checkType) {
                    case 256: 
                    case 257: 
                    case 512: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        if (flowInfo.cannotBeNull(var)) {
                            if (checkType == 512) {
                                if ((this.tagBits & 4) == 0) {
                                    scope.problemReporter().variableRedundantCheckOnNonNull(var, reference);
                                }
                                if (flowInfo.isMarkedAsNullOrNonNullInAssertExpression(var)) return;
                                flowInfo.initsWhenFalse().setReachMode(2);
                                return;
                            } else {
                                if (checkType != 256) return;
                                if ((this.tagBits & 4) == 0) {
                                    scope.problemReporter().variableNonNullComparedToNull(var, reference);
                                }
                                if (flowInfo.isMarkedAsNullOrNonNullInAssertExpression(var)) return;
                                flowInfo.initsWhenTrue().setReachMode(2);
                            }
                            return;
                        }
                        if (flowInfo.canOnlyBeNull(var)) {
                            switch (checkType & 0xFFFFFF00) {
                                case 256: {
                                    if ((checkType & 0xFF) == 1 && (reference.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().variableNullReference(var, reference);
                                        return;
                                    }
                                    if ((this.tagBits & 4) == 0) {
                                        scope.problemReporter().variableRedundantCheckOnNull(var, reference);
                                    }
                                    if (flowInfo.isMarkedAsNullOrNonNullInAssertExpression(var)) return;
                                    flowInfo.initsWhenFalse().setReachMode(2);
                                    return;
                                }
                                case 512: {
                                    if ((checkType & 0xFF) == 1 && (reference.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().variableNullReference(var, reference);
                                        return;
                                    }
                                    if ((this.tagBits & 4) == 0) {
                                        scope.problemReporter().variableNullComparedToNonNull(var, reference);
                                    }
                                    if (flowInfo.isMarkedAsNullOrNonNullInAssertExpression(var)) return;
                                    flowInfo.initsWhenTrue().setReachMode(2);
                                    return;
                                }
                                case 768: {
                                    scope.problemReporter().variableRedundantNullAssignment(var, reference);
                                    return;
                                }
                                case 1024: {
                                    scope.problemReporter().variableNullInstanceof(var, reference);
                                    return;
                                }
                            }
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(var)) break block56;
                        switch (checkType & 0xFFFFFF00) {
                            case 256: {
                                if ((checkType & 0xFF) == 1 && (reference.implicitConversion & 0x400) != 0) {
                                    scope.problemReporter().variablePotentialNullReference(var, reference);
                                    return;
                                }
                                break block56;
                            }
                            case 512: {
                                if ((checkType & 0xFF) == 1 && (reference.implicitConversion & 0x400) != 0) {
                                    scope.problemReporter().variablePotentialNullReference(var, reference);
                                    return;
                                }
                                break block56;
                            }
                        }
                        break block56;
                    }
                    case 3: {
                        if (flowInfo.cannotBeNull(var)) {
                            return;
                        }
                        if (flowInfo.canOnlyBeNull(var)) {
                            scope.problemReporter().variableNullReference(var, reference);
                            return;
                        }
                        break block56;
                    }
                }
                break block56;
            }
            block14 : switch (checkType) {
                case 256: 
                case 512: {
                    if (flowInfo.isDefinitelyNonNull(var)) {
                        if (checkType == 512) {
                            if ((this.tagBits & 4) == 0) {
                                scope.problemReporter().variableRedundantCheckOnNonNull(var, reference);
                            }
                            if (flowInfo.isMarkedAsNullOrNonNullInAssertExpression(var)) return;
                            flowInfo.initsWhenFalse().setReachMode(2);
                            return;
                        } else {
                            if ((this.tagBits & 4) == 0) {
                                scope.problemReporter().variableNonNullComparedToNull(var, reference);
                            }
                            if (flowInfo.isMarkedAsNullOrNonNullInAssertExpression(var)) return;
                            flowInfo.initsWhenTrue().setReachMode(2);
                        }
                        return;
                    }
                }
                case 257: 
                case 513: 
                case 769: 
                case 1025: {
                    if (flowInfo.isDefinitelyNull(var)) {
                        switch (checkType & 0xFFFFFF00) {
                            case 256: {
                                if ((checkType & 0xFF) == 1 && (reference.implicitConversion & 0x400) != 0) {
                                    scope.problemReporter().variableNullReference(var, reference);
                                    return;
                                }
                                if ((this.tagBits & 4) == 0) {
                                    scope.problemReporter().variableRedundantCheckOnNull(var, reference);
                                }
                                if (flowInfo.isMarkedAsNullOrNonNullInAssertExpression(var)) return;
                                flowInfo.initsWhenFalse().setReachMode(2);
                                return;
                            }
                            case 512: {
                                if ((checkType & 0xFF) == 1 && (reference.implicitConversion & 0x400) != 0) {
                                    scope.problemReporter().variableNullReference(var, reference);
                                    return;
                                }
                                if ((this.tagBits & 4) == 0) {
                                    scope.problemReporter().variableNullComparedToNonNull(var, reference);
                                }
                                if (flowInfo.isMarkedAsNullOrNonNullInAssertExpression(var)) return;
                                flowInfo.initsWhenTrue().setReachMode(2);
                                return;
                            }
                            case 768: {
                                scope.problemReporter().variableRedundantNullAssignment(var, reference);
                                return;
                            }
                            case 1024: {
                                scope.problemReporter().variableNullInstanceof(var, reference);
                                return;
                            }
                        }
                        break;
                    }
                    if (!flowInfo.isPotentiallyNull(var)) break;
                    switch (checkType & 0xFFFFFF00) {
                        case 256: {
                            if ((checkType & 0xFF) != 1 || (reference.implicitConversion & 0x400) == 0) break block14;
                            scope.problemReporter().variablePotentialNullReference(var, reference);
                            return;
                        }
                        case 512: {
                            if ((checkType & 0xFF) != 1 || (reference.implicitConversion & 0x400) == 0) break block14;
                            scope.problemReporter().variablePotentialNullReference(var, reference);
                            return;
                        }
                    }
                    break;
                }
                case 3: {
                    if (flowInfo.isDefinitelyNull(var)) {
                        scope.problemReporter().variableNullReference(var, reference);
                        return;
                    }
                    if (flowInfo.isPotentiallyNull(var)) {
                        scope.problemReporter().variablePotentialNullReference(var, reference);
                        return;
                    }
                    if (!flowInfo.isDefinitelyNonNull(var)) break;
                    return;
                }
            }
        }
        if ((this.tagBits & 4) != 0 && checkType != 3 && (checkType & 0xFFFFFF00) != 768 && (checkType & 0xFFFFFF00) != 1024) return;
        this.recordNullReference(var, reference, checkType);
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int i = 0;
        while (i < this.assignCount) {
            if (this.finalAssignments[i] == reference) {
                this.finalAssignments[i] = null;
                this.finalVariables[i] = null;
                return;
            }
            ++i;
        }
    }

    protected void recordNullReference(VariableBinding var, Expression expression, int status) {
        if (this.nullCount == 0) {
            this.nullVariables = new VariableBinding[5];
            this.nullReferences = new Expression[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullVariables.length) {
            int newLength = this.nullCount * 2;
            this.nullVariables = new VariableBinding[newLength];
            System.arraycopy(this.nullVariables, 0, this.nullVariables, 0, this.nullCount);
            this.nullReferences = new Expression[newLength];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[newLength];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullVariables[this.nullCount] = var;
        this.nullReferences[this.nullCount] = expression;
        this.nullCheckTypes[this.nullCount++] = status;
    }

    protected boolean internalRecordNullityMismatch(Expression expression, int nullStatus, TypeBinding expectedType, int checkType) {
        if (nullStatus == 1 || (this.tagBits & 1) != 0 && nullStatus != 2) {
            this.recordExpectedType(expectedType, this.nullCount);
            this.recordNullReference(expression.localVariableBinding(), expression, checkType);
            return true;
        }
        return false;
    }
}

