/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.util;

import java.lang.reflect.Array;
import java.util.List;
import wsattacker.util.SortedUniqueList;

public class Category<Key extends Comparable<Key>, Leaf extends Comparable<Leaf>>
implements Comparable<Category<Key, Leaf>> {
    Key name;
    List<Category<Key, Leaf>> subCategorys;
    List<Leaf> leafs;

    public Category(Key name) {
        this.name = name;
        this.subCategorys = new SortedUniqueList<Category<Key, Leaf>>();
        this.leafs = new SortedUniqueList<Leaf>();
    }

    public Key getName() {
        return this.name;
    }

    public List<Category<Key, Leaf>> getSubCategorys() {
        return this.subCategorys;
    }

    public Category<Key, Leaf> getSubCategory(Key[] path) {
        Category<Key, Leaf> ret = this;
        for (Key key : path) {
            int index = ret.getSubCategorys().indexOf(new Category<Key, Leaf>(key));
            if (index < 0) {
                ret = null;
                break;
            }
            ret = ret.getSubCategorys().get(index);
        }
        return ret;
    }

    public Category<Key, Leaf> getSubCategory(Key key) {
        Comparable[] keys = (Comparable[])Array.newInstance(key.getClass(), 1);
        keys[0] = key;
        return this.getSubCategory((Key)keys);
    }

    public Category<Key, Leaf> createPath(Key[] path) {
        Category<Key, Leaf> zwerg = this;
        for (Key key : path) {
            zwerg.createPath(key);
            zwerg = zwerg.getSubCategory(key);
        }
        return zwerg;
    }

    public void createPath(Key path) {
        this.addCategory(new Category<Key, Leaf>(path));
    }

    public List<Leaf> getLeafs() {
        return this.leafs;
    }

    public List<Leaf> getLeafsRecursive() {
        SortedUniqueList list = new SortedUniqueList();
        list.addAll(this.getLeafs());
        for (Category<Key, Leaf> sub : this.subCategorys) {
            list.addAll(sub.getLeafsRecursive());
        }
        return list;
    }

    public Object getNode(int index) {
        int subtreeSize = this.getSubCategorys().size();
        if (index < subtreeSize) {
            return this.getSubCategorys().get(index);
        }
        return this.getLeafs().get(index - subtreeSize);
    }

    public int getIndexOfNode(Object node) {
        if (this.getSubCategorys().contains(node)) {
            return this.getSubCategorys().indexOf(node);
        }
        if (this.getLeafs().contains(node)) {
            return this.getSubCategorys().size() + this.getLeafs().indexOf(node);
        }
        return 0;
    }

    public int countNodes() {
        return this.getLeafs().size() + this.getSubCategorys().size();
    }

    public boolean isLeaf(Object node) {
        return this.getLeafs().contains(node);
    }

    public boolean addLeaf(Leaf leaf) {
        return this.getLeafs().add(leaf);
    }

    public boolean removeLeaf(Leaf leaf) {
        return this.getLeafs().remove(leaf);
    }

    public Category<Key, Leaf> addCategory(Category<Key, Leaf> category) {
        Category<Key, Leaf> containedCategory;
        if (this.getSubCategorys().contains(category)) {
            int containedIndex = this.getSubCategorys().indexOf(category);
            containedCategory = this.getSubCategorys().get(containedIndex);
            containedCategory.composeCategory(category);
        } else {
            containedCategory = new Category<Key, Leaf>(category.getName());
            containedCategory.composeCategory(category);
            this.getSubCategorys().add(containedCategory);
        }
        return containedCategory;
    }

    public Category<Key, Leaf> composeCategory(Category<Key, Leaf> category) {
        this.getLeafs().addAll(category.getLeafs());
        for (Category<Key, Leaf> sub : category.getSubCategorys()) {
            this.addCategory(sub);
        }
        category.setName(this.getName());
        category.setSubCategorys(this.getSubCategorys());
        category.setLeafs(this.getLeafs());
        return this;
    }

    protected void setSubCategorys(List<Category<Key, Leaf>> list) {
        this.subCategorys = list;
    }

    protected void setLeafs(List<Leaf> list) {
        this.leafs = list;
    }

    protected void setName(Key name) {
        this.name = name;
    }

    public void removeAllLeafs() {
        this.getLeafs().clear();
    }

    public void removeAllSubCategorys(boolean recursive) {
        if (recursive) {
            for (Category<Key, Leaf> category : this.getSubCategorys()) {
                category.removeAllLeafs();
                category.removeAllSubCategorys(recursive);
            }
        }
        this.getSubCategorys().clear();
    }

    public void removeAllNodes(boolean recursive) {
        this.removeAllLeafs();
        this.removeAllSubCategorys(recursive);
    }

    @Override
    public int compareTo(Category<Key, Leaf> category) {
        return this.name.compareTo(category.getName());
    }

    public boolean equals(Object o) {
        if (o.getClass().isAssignableFrom(this.getClass())) {
            return ((Category)o).getName().equals(this.getName());
        }
        return false;
    }

    public void print() {
        this.print(0);
    }

    public void print(int indent) {
        int count = indent * 4;
        char[] chars = new char[count];
        while (count > 0) {
            chars[--count] = 32;
        }
        String padding = new String(chars);
        System.out.format("%s    `-- %s (S:%d|L:%d)\n", padding, this.getName(), this.getSubCategorys().size(), this.getLeafs().size());
        ++indent;
        for (Comparable comparable : this.getLeafs()) {
            System.out.println(padding + "        `-- (+) " + comparable);
        }
        for (Category category : this.getSubCategorys()) {
            category.print(indent);
        }
    }

    public String toString() {
        return this.getName().toString();
    }
}

