/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.testsuite;

import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlProjectFactory;
import com.eviware.soapui.support.SoapUIException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.xmlbeans.XmlException;
import org.jdesktop.beans.AbstractBean;
import wsattacker.main.composition.testsuite.WsdlChangeObserver;
import wsattacker.main.testsuite.CurrentInterface;
import wsattacker.main.testsuite.CurrentOperation;
import wsattacker.main.testsuite.CurrentRequest;

public final class TestSuite
extends AbstractBean {
    private static final TestSuite instance = new TestSuite();
    private static final Logger LOG = Logger.getLogger(TestSuite.class);
    public static final String PROP_PROJECT = "project";
    public static final String PROP_CURRENTINTERFACE = "currentInterface";
    public static final String PROP_CURRENTOPERATION = "currentOperation";
    public static final String PROP_CURRENTREQUEST = "currentRequest";
    private final List<WsdlChangeObserver> wsdlChangeObserver = new ArrayList<WsdlChangeObserver>();
    private WsdlProject project = this.createEmptyProject();
    private CurrentInterface currentInterface = new CurrentInterface();
    private CurrentOperation currentOperation;
    private CurrentRequest currentRequest;

    public static TestSuite getInstance() {
        return instance;
    }

    public TestSuite() {
        this.currentInterface.setTestSuite(this);
        this.currentOperation = new CurrentOperation();
        this.currentOperation.setCurrentInterface(this.currentInterface);
        this.currentRequest = new CurrentRequest();
        this.currentRequest.setCurrentOperation(this.currentOperation);
    }

    private WsdlProject createEmptyProject() {
        WsdlProject project = null;
        WsdlProjectFactory fac = new WsdlProjectFactory();
        try {
            project = fac.createNew();
        }
        catch (XmlException e) {
            LOG.fatal("Could not Instanciate WsdlProject: " + e.getMessage());
        }
        catch (IOException e) {
            LOG.fatal("Could not Instanciate WsdlProject: " + e.getMessage());
        }
        catch (SoapUIException e) {
            LOG.fatal("Could not Instanciate WsdlProject: " + e.getMessage());
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource("log4j.properties");
        PropertyConfigurator.configure(url);
        return project;
    }

    public void loadWsdl(String url) throws SoapUIException, MalformedURLException {
        assert (this.getProject() != null);
        if (url.length() > 0) {
            if (new File(url).exists()) {
                url = new File(url).toURI().toURL().toString();
            }
            if (url.toUpperCase().endsWith("WADL")) {
                throw new UnsupportedOperationException("WADL not yet supported");
            }
            this.importWsdl(url);
        }
    }

    private void importWsdl(String url) throws SoapUIException {
        WsdlProject project = this.createEmptyProject();
        WsdlInterfaceFactory.importWsdl(project, url, false);
        this.setProject(project);
        LOG.info("Successfully loaded wsdl");
    }

    public WsdlProject getProject() {
        return this.project;
    }

    protected void setProject(WsdlProject newProject) {
        WsdlProject oldProject = this.project;
        this.project = newProject;
        this.firePropertyChange(PROP_PROJECT, oldProject, newProject);
        this.notifyCurrentWsdlChangeObservers();
    }

    public CurrentInterface getCurrentInterface() {
        return this.currentInterface;
    }

    protected void setCurrentInterface(CurrentInterface newCurrentInterface) {
        CurrentInterface oldCurrentInterface = this.currentInterface;
        this.currentInterface = newCurrentInterface;
        this.firePropertyChange(PROP_CURRENTINTERFACE, oldCurrentInterface, newCurrentInterface);
    }

    public CurrentOperation getCurrentOperation() {
        return this.currentOperation;
    }

    protected void setCurrentOperation(CurrentOperation newCurrentOperation) {
        CurrentOperation oldCurrentOperation = this.currentOperation;
        this.currentOperation = newCurrentOperation;
        this.firePropertyChange(PROP_CURRENTOPERATION, oldCurrentOperation, newCurrentOperation);
    }

    public CurrentRequest getCurrentRequest() {
        return this.currentRequest;
    }

    protected void setCurrentRequest(CurrentRequest newCurrentRequest) {
        CurrentRequest oldCurrentRequest = this.currentRequest;
        this.currentRequest = newCurrentRequest;
        this.firePropertyChange(PROP_CURRENTREQUEST, oldCurrentRequest, newCurrentRequest);
    }

    @Deprecated
    public void addCurrentWsdlChangeObserver(WsdlChangeObserver o) {
        this.wsdlChangeObserver.add(o);
    }

    @Deprecated
    public void removeCurrentWsdlChangeObserver(WsdlChangeObserver o) {
        this.wsdlChangeObserver.remove(o);
    }

    @Deprecated
    private void notifyCurrentWsdlChangeObservers() {
        for (WsdlChangeObserver o : this.wsdlChangeObserver) {
            o.wsdlChanged(this);
        }
    }
}

