/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.testsuite;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdesktop.beans.AbstractBean;
import wsattacker.main.composition.testsuite.CurrentOperationObserver;
import wsattacker.main.testsuite.CurrentInterface;

public class CurrentOperation
extends AbstractBean
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CurrentOperation.class);
    public static final String PROP_WSDLOPERATION = "wsdlOperation";
    private WsdlOperation wsdlOperation;
    private CurrentInterface currentInterface;
    private final List<CurrentOperationObserver> observers = new ArrayList<CurrentOperationObserver>();

    public CurrentInterface getCurrentInterface() {
        return this.currentInterface;
    }

    public void setCurrentInterface(CurrentInterface newCurrentInterface) {
        CurrentInterface oldInterface = this.currentInterface;
        if (oldInterface != null) {
            oldInterface.removePropertyChangeListener(this);
        }
        this.currentInterface = newCurrentInterface;
        if (newCurrentInterface != null) {
            newCurrentInterface.addPropertyChangeListener("wsdlInterface", this);
        }
    }

    public WsdlOperation getWsdlOperation() {
        return this.wsdlOperation;
    }

    public void setWsdlOperation(WsdlOperation newWsdlOperation) {
        WsdlOperation oldWsdlOperation = this.wsdlOperation;
        this.wsdlOperation = newWsdlOperation;
        this.firePropertyChange(PROP_WSDLOPERATION, oldWsdlOperation, newWsdlOperation);
        this.notifyCurrentOperationObservers(newWsdlOperation, oldWsdlOperation);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if ("currentInterface".equals(propName)) {
            LOG.info("Detected Service change");
            CurrentInterface newCI = (CurrentInterface)pce.getNewValue();
            WsdlInterface wsdlInterface = newCI.getWsdlInterface();
            if (wsdlInterface != null && wsdlInterface.getOperationCount() > 0) {
                WsdlOperation operation = wsdlInterface.getOperationAt(0);
                LOG.info("Set default operation to: " + operation.getName());
                this.setWsdlOperation(operation);
            } else {
                this.setWsdlOperation(null);
            }
        }
    }

    @Deprecated
    public void addCurrentOperationObserver(CurrentOperationObserver o) {
        this.observers.add(o);
    }

    @Deprecated
    public void removeCurrentOperationObserver(CurrentOperationObserver o) {
        this.observers.remove(o);
    }

    private void notifyCurrentOperationObservers(WsdlOperation newOperation, WsdlOperation oldOperation) {
        if (newOperation == null) {
            for (CurrentOperationObserver o : this.observers) {
                o.noCurrentOperation();
            }
        } else {
            for (CurrentOperationObserver o : this.observers) {
                o.currentOperationChanged(newOperation, oldOperation);
            }
        }
    }
}

