/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.plugin.option;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.model.iface.Operation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import wsattacker.main.plugin.option.OptionSimpleChoice;
import wsattacker.main.testsuite.TestSuite;

public class OptionSoapAction
extends OptionSimpleChoice
implements PropertyChangeListener {
    private static final long serialVersionUID = 2L;
    private static final String MANUAL = "Manual Action";

    public OptionSoapAction(String name, String description) {
        super(name, description);
        this.clearChoices();
        this.setSelectedIndex(0);
        TestSuite.getInstance().getCurrentOperation().addPropertyChangeListener("wsdlOperation", this);
    }

    private void clearChoices() {
        ArrayList<String> newChoices = new ArrayList<String>();
        newChoices.add(MANUAL);
        this.setChoices(newChoices);
    }

    private void currentOperationChanged(WsdlOperation newOperation, WsdlOperation oldOperation) {
        List<Operation> operationList = newOperation.getInterface().getOperationList();
        ArrayList<String> newChoices = new ArrayList<String>(operationList.size());
        for (Operation operation : operationList) {
            String name = operation.getName();
            newChoices.add(name);
        }
        if (newOperation.getName().equals(this.getValueAsString())) {
            this.setSelectedIndex(0);
        }
        this.setChoices(newChoices);
    }

    private void noCurrentOperation() {
        this.clearChoices();
        this.setSelectedIndex(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if ("wsdlOperation".equals(propName)) {
            WsdlOperation newOperation = (WsdlOperation)pce.getNewValue();
            if (newOperation == null) {
                this.noCurrentOperation();
            }
            WsdlOperation oldOperation = (WsdlOperation)pce.getOldValue();
            this.currentOperationChanged(newOperation, oldOperation);
        }
    }
}

