/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.plugin.option;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import wsattacker.main.composition.plugin.option.AbstractOptionChoice;

public class OptionSimpleChoice
extends AbstractOptionChoice {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CHOICES = "choices";
    public static final String PROP_SELECTEDINDEX = "selectedIndex";
    public static final String PROP_SELECTEDASSTRING = "selectedAsString";
    private List<String> choices;
    private int selected;

    public OptionSimpleChoice(String name, String description) {
        this(name, new ArrayList<String>(), 0);
        this.choices.add("No hoices available");
    }

    public OptionSimpleChoice(String name, List<String> choices, int selected) {
        this(name, choices, selected, "");
    }

    public OptionSimpleChoice(String name, List<String> choices, int selected, String description) {
        super(name, description);
        this.choices = choices;
        if (selected >= 0 && selected < choices.size()) {
            this.selected = selected;
        }
    }

    @Override
    public boolean isValid(int choice) {
        return choice >= 0 && choice < this.choices.size();
    }

    @Override
    public boolean isValid(String value) {
        return this.choices.contains(value);
    }

    @Override
    public void parseValue(String value) {
        if (!this.isValid(value)) {
            throw new IllegalArgumentException(String.format("isValid(\"%s\") returned false", value));
        }
        this.setSelectedIndex(this.choices.indexOf(value));
    }

    @Override
    public String getSelectedAsString() {
        return this.choices.get(this.selected);
    }

    @Override
    public List<String> getChoices() {
        return Collections.unmodifiableList(this.choices);
    }

    @Override
    public void setSelectedAsString(String value) {
        this.parseValue(value);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.isValid(index)) {
            int oldSelected = this.selected;
            String oldString = this.getValueAsString();
            this.selected = index;
            String newString = this.getValueAsString();
            this.firePropertyChange(PROP_SELECTEDINDEX, oldSelected, this.selected);
            this.firePropertyChange(PROP_SELECTEDASSTRING, oldString, newString);
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.selected;
    }

    @Override
    public void setChoices(List<String> choices) {
        List<String> oldChoices = this.choices;
        this.choices = choices;
        this.firePropertyChange(PROP_CHOICES, oldChoices, choices);
    }
}

