/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.PluginManagerListener;
import wsattacker.main.composition.plugin.PluginObserver;
import wsattacker.main.plugin.PluginContainer;
import wsattacker.main.plugin.PluginState;

public final class PluginManager
implements PluginObserver,
Iterable<AbstractPlugin> {
    private static final Logger LOG = Logger.getLogger(PluginManager.class);
    private static final PluginManager singleton = new PluginManager();
    PluginContainer allPlugins = new PluginContainer();
    PluginContainer activePlugins = new PluginContainer();
    private final transient List<PluginManagerListener> listeners = new ArrayList<PluginManagerListener>();

    private PluginManager() {
    }

    public static PluginManager getInstance() {
        return singleton;
    }

    public void loadAvailableJars(File jarDir) {
        if (jarDir.exists() && jarDir.isDirectory()) {
            for (File file : jarDir.listFiles()) {
                if (!file.isFile() || !file.getName().toLowerCase().endsWith("jar")) continue;
                LOG.info("Loading " + file.getAbsolutePath());
                this.addToClasspath(file);
            }
        }
    }

    private void addToClasspath(File file) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)ClassLoader.getSystemClassLoader(), file.toURI().toURL());
        }
        catch (NoSuchMethodException ex) {
            LOG.error(ex);
        }
        catch (SecurityException ex) {
            LOG.error(ex);
        }
        catch (MalformedURLException ex) {
            LOG.error(ex);
        }
        catch (IllegalAccessException ex) {
            LOG.error(ex);
        }
        catch (IllegalArgumentException ex) {
            LOG.error(ex);
        }
        catch (InvocationTargetException ex) {
            LOG.error(ex);
        }
    }

    public void loadAvailablePlugins(File pluginDir) {
        Logger logger = Logger.getLogger(this.getClass());
        this.removeAllPlugins();
        logger.info("(Re-)laoding available Plugins");
        LOG.info("Searching for Plugins in Directory: " + pluginDir.getAbsolutePath());
        this.loadAvailableJars(pluginDir);
        ServiceLoader<AbstractPlugin> loader = ServiceLoader.load(AbstractPlugin.class);
        int anz = 0;
        int suc = 0;
        Iterator<AbstractPlugin> it = loader.iterator();
        while (it.hasNext()) {
            ++anz;
            AbstractPlugin o = null;
            try {
                o = it.next();
            }
            catch (ServiceConfigurationError sce) {
                LOG.error(sce.getMessage());
                continue;
            }
            AbstractPlugin plugin = o;
            try {
                plugin.initializePlugin();
            }
            catch (UnsupportedOperationException e) {
                logger.warn("Could not load Plugin '" + plugin.getClass().getName() + "' / " + e.getMessage());
                continue;
            }
            this.addPlugin(plugin);
            logger.trace("Loaded Plugin '" + plugin.getName() + "'");
            ++suc;
        }
        String loaded = String.format("Successfuly loaded %d of %d plugins", suc, anz);
        if (suc < anz) {
            LOG.warn(loaded);
        } else {
            LOG.info(loaded);
        }
        this.notifyContainerChanged();
    }

    public void savePlugins(File file) throws IOException {
        ArrayList<String> activeList = new ArrayList<String>();
        for (AbstractPlugin plugin : this.activePlugins) {
            activeList.add(plugin.getName());
        }
        FileOutputStream fs = new FileOutputStream(file);
        ObjectOutputStream os = new ObjectOutputStream(fs);
        os.writeObject(this.allPlugins);
        os.writeObject(activeList);
        os.close();
    }

    public void loadPlugins(File file) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object pluginObject = ois.readObject();
        Object activeListObject = ois.readObject();
        ois.close();
        if (!(pluginObject instanceof PluginContainer)) {
            LOG.error("Incompatible Filetype. Could not read plugin configuration.");
            return;
        }
        PluginContainer collection = (PluginContainer)pluginObject;
        for (AbstractPlugin savedPlugin : collection) {
            AbstractPlugin currentPlugin = this.allPlugins.getByName(savedPlugin.getName());
            if (currentPlugin != null) {
                currentPlugin.restoreConfiguration(savedPlugin);
                continue;
            }
            LOG.warn("Could not restore Plugin-Configuration for Plugin '" + savedPlugin.getName() + "' - Plugin not available!");
        }
        if (!(activeListObject instanceof List)) {
            LOG.error("Incompatible Filetype. Could not read active plugin list.");
            return;
        }
        List activeList = (List)activeListObject;
        for (Object active : activeList) {
            if (!(active instanceof String)) continue;
            this.setActive(this.getByName((String)active), true);
        }
    }

    public void removeAllPlugins() {
        Iterator<AbstractPlugin> iter = this.allPlugins.iterator();
        while (iter.hasNext()) {
            AbstractPlugin plugin = iter.next();
            plugin.removePluginObserver(this);
            this.activePlugins.remove(plugin);
            iter.remove();
        }
    }

    public void removePlugin(AbstractPlugin plugin) {
        plugin.removePluginObserver(this);
        this.activePlugins.remove(plugin);
        this.allPlugins.remove(plugin);
    }

    public void addPlugin(AbstractPlugin plugin) {
        plugin.addPluginObserver(this);
        this.allPlugins.add(plugin);
    }

    public boolean isActive(AbstractPlugin plugin) {
        return this.activePlugins.contains(plugin);
    }

    public void setActive(AbstractPlugin plugin, boolean active) {
        if (active) {
            this.activePlugins.add(plugin);
        } else {
            this.activePlugins.remove(plugin);
        }
        this.notifyActiveChanged(plugin, active);
    }

    public void setAllActive(boolean active) {
        for (AbstractPlugin plugin : this.allPlugins) {
            this.setActive(plugin, active);
        }
    }

    @Override
    public Iterator<AbstractPlugin> iterator() {
        return this.allPlugins.iterator();
    }

    public Iterator<AbstractPlugin> getActivePluginIterator() {
        return this.activePlugins.iterator();
    }

    public AbstractPlugin getByName(String pluginName) {
        return this.allPlugins.getByName(pluginName);
    }

    public AbstractPlugin getByIndex(int index) {
        return this.allPlugins.getByIndex(index);
    }

    public AbstractPlugin getActive(int index) {
        return this.activePlugins.getByIndex(index);
    }

    public int indexOf(AbstractPlugin plugin) {
        return this.allPlugins.indexOf(plugin);
    }

    public int indexOfActive(AbstractPlugin plugin) {
        return this.activePlugins.indexOf(plugin);
    }

    public int countPlugins() {
        return this.allPlugins.size();
    }

    public int countActivePlugins() {
        return this.activePlugins.size();
    }

    public void addListener(PluginManagerListener o) {
        this.listeners.add(o);
    }

    public void removeListener(PluginManagerListener o) {
        this.listeners.remove(o);
    }

    private void notifyActiveChanged(AbstractPlugin plugin, boolean active) {
        for (PluginManagerListener o : this.listeners) {
            o.pluginActiveStateChanged(plugin, active);
        }
    }

    private void notifyContainerChanged() {
        for (PluginManagerListener o : this.listeners) {
            o.pluginContainerChanged();
        }
    }

    @Override
    public void currentPointsChanged(AbstractPlugin plugin, int newPoints) {
        for (PluginObserver pluginObserver : this.listeners) {
            pluginObserver.currentPointsChanged(plugin, newPoints);
        }
    }

    @Override
    public void pluginStateChanged(AbstractPlugin plugin, PluginState newState, PluginState oldState) {
        for (PluginObserver pluginObserver : this.listeners) {
            pluginObserver.pluginStateChanged(plugin, newState, oldState);
        }
    }
}

