/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.composition.plugin.option;

import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.gui.component.pluginconfiguration.option.OptionIntegerGUI_NB;
import wsattacker.main.composition.plugin.option.AbstractOption;

public abstract class AbstractOptionInteger
extends AbstractOption {
    private static final long serialVersionUID = 2L;
    public static final String PROP_VALUE = "value";
    private int value;

    public AbstractOptionInteger(String name, int value) {
        this(name, value, "");
    }

    public AbstractOptionInteger(String name, int value, String description) {
        super(name, description);
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (!this.isValid(value)) {
            throw new IllegalArgumentException(String.format("isValid(\"%s\") returned false", value));
        }
        int oldValue = this.value;
        this.value = value;
        this.firePropertyChange(PROP_VALUE, oldValue, value);
    }

    @Override
    public abstract boolean isValid(String var1);

    public abstract boolean isValid(int var1);

    @Override
    public void parseValue(String value) {
        this.setValue(Integer.parseInt(value));
    }

    @Override
    public String getValueAsString() {
        return Integer.toString(this.value);
    }

    @Override
    public OptionGUI createOptionGUI() {
        return new OptionIntegerGUI_NB(this);
    }
}

