/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.jdesktop.beans.AbstractBean;
import wsattacker.main.config.HttpConfig;
import wsattacker.persistence.XmlPersistenceError;

@XmlRootElement(name="WS-Attacker-Config")
public class Preferences
extends AbstractBean {
    private static final Logger LOG;
    private static final File DEFAULT_CONFIG_FILE;
    private static final Preferences preferences;
    public static final String PROP_LASTWSDL = "lastWsdl";
    public static final String PROP_CREATEOPTIONALELEMENTS = "createOptionalElements";
    public static final String PROP_HTTPCONFIG = "httpConfig";
    private String lastWsdl = "http://localhost:8080/axis2/services/Version?wsdl";
    private boolean createOptionalElements = true;
    private HttpConfig httpConfig = new HttpConfig();

    public static Preferences getInstance() {
        return preferences;
    }

    public static Preferences readFromDisk() throws XmlPersistenceError {
        return Preferences.readFromDisk(DEFAULT_CONFIG_FILE);
    }

    public static Preferences readFromDisk(File fileToLoad) throws XmlPersistenceError {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Preferences.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Preferences loaded = (Preferences)jaxbUnmarshaller.unmarshal(fileToLoad);
            LOG.info(String.format("Loaded successfully config from '%s'", fileToLoad.getAbsoluteFile()));
            return loaded;
        }
        catch (JAXBException ex) {
            throw new XmlPersistenceError(String.format("Could not load config from File '%s'", fileToLoad.getAbsoluteFile()), ex);
        }
    }

    public static void saveToDisk(Preferences pref, File fileToSaveIn) throws XmlPersistenceError {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Preferences.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)pref, fileToSaveIn);
            LOG.info(String.format("Saved successfully config to '%s'", fileToSaveIn.getAbsoluteFile()));
        }
        catch (JAXBException ex) {
            throw new XmlPersistenceError(String.format("Could not save config to File '%s'", fileToSaveIn.getAbsoluteFile()), ex);
        }
    }

    public static void saveToDisk(File fileToSaveIn) throws XmlPersistenceError {
        Preferences.saveToDisk(Preferences.getInstance(), fileToSaveIn);
    }

    public static void saveToDisk() throws XmlPersistenceError {
        Preferences.saveToDisk(DEFAULT_CONFIG_FILE);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        HttpConfig oldHttpConfig = this.httpConfig;
        this.httpConfig = httpConfig;
        this.firePropertyChange(PROP_HTTPCONFIG, oldHttpConfig, httpConfig);
    }

    public String getLastWsdl() {
        return this.lastWsdl;
    }

    public void setLastWsdl(String lastWsdl) {
        String oldLastWsdl = this.lastWsdl;
        this.lastWsdl = lastWsdl;
        this.firePropertyChange(PROP_LASTWSDL, oldLastWsdl, lastWsdl);
    }

    public boolean isCreateOptionalElements() {
        return this.createOptionalElements;
    }

    public void setCreateOptionalElements(boolean createOptionalElements) {
        boolean oldCreateOptionalElements = this.createOptionalElements;
        this.createOptionalElements = createOptionalElements;
        this.firePropertyChange(PROP_CREATEOPTIONALELEMENTS, oldCreateOptionalElements, createOptionalElements);
    }

    static {
        Preferences readPreferences;
        LOG = Logger.getLogger(Preferences.class);
        DEFAULT_CONFIG_FILE = new File("wsattacker_config.xml");
        try {
            readPreferences = Preferences.readFromDisk(DEFAULT_CONFIG_FILE);
        }
        catch (XmlPersistenceError ex) {
            LOG.info(String.format("Could not load config '%s'. Reason: %s", DEFAULT_CONFIG_FILE.getAbsoluteFile(), ex));
            readPreferences = new Preferences();
        }
        preferences = readPreferences;
    }
}

