/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.target.subcomponent;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.model.iface.Request;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.main.testsuite.TestSuite;
import wsattacker.util.SoapUtilities;

public class NamespaceTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CONTROLLER = "controller";
    private final String[] columnNames = new String[]{"Prefix", "Uri"};
    private Map<String, String> content = new HashMap<String, String>();
    private ControllerInterface controller = null;
    private static final Logger LOG = Logger.getLogger(NamespaceTableModel.class);
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.content.size();
    }

    @Override
    public String getColumnName(int num) {
        return this.columnNames[num];
    }

    @Override
    public boolean isCellEditable(int y, int x) {
        return false;
    }

    @Override
    public Object getValueAt(int y, int x) {
        if (this.content.isEmpty()) {
            return null;
        }
        Object[] keyArray = this.content.keySet().toArray();
        if (x == 0) {
            return keyArray[y].toString();
        }
        if (x == 1) {
            return this.content.get(keyArray[y]).toString();
        }
        return null;
    }

    public void setNamespaceData(Request request) throws SOAPException {
        this.setNamespaceData(request.getRequestContent());
    }

    public void setNamespaceData(String request) throws SOAPException {
        SOAPMessage msg = SoapUtilities.stringToSoap(request);
        Map<String, String> namespaces = SoapUtilities.allNamespaces((SOAPElement)msg.getSOAPPart().getEnvelope());
        this.setNamespaceData(namespaces);
    }

    public void setNamespaceData(Map<String, String> nsContent) {
        if (nsContent == null) {
            return;
        }
        this.content = nsContent;
        this.fireTableDataChanged();
    }

    public void currentRequestChanged(WsdlRequest newRequest, WsdlRequest oldRequest) {
        try {
            this.setNamespaceData(newRequest);
        }
        catch (SOAPException e) {
            LOG.warn("Invalid Request: " + e.getMessage());
        }
    }

    public void currentRequestContentChanged(String newContent, String oldContent) {
        try {
            this.setNamespaceData(newContent);
        }
        catch (SOAPException e) {
            LOG.warn("Invalid Request: " + e.getMessage());
        }
    }

    public void noCurrentRequest() {
        this.setNamespaceData(new HashMap<String, String>());
    }

    public void noCurrentRequestcontent() {
        this.setNamespaceData(new HashMap<String, String>());
    }

    public ControllerInterface getController() {
        return this.controller;
    }

    public void setController(ControllerInterface controller) {
        ControllerInterface oldController = controller;
        this.controller = controller;
        if (oldController != null) {
            oldController.getTestSuite().getCurrentRequest().removePropertyChangeListener(this);
        }
        if (this.controller != null) {
            TestSuite testSuite = this.controller.getTestSuite();
            testSuite.getCurrentRequest().addPropertyChangeListener("wsdlRequest", this);
            testSuite.getCurrentRequest().addPropertyChangeListener("wsdlRequestContent", this);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_CONTROLLER, oldController, controller);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if (propName.equals("wsdlRequest")) {
            WsdlRequest newRequest = (WsdlRequest)pce.getNewValue();
            WsdlRequest oldRequest = (WsdlRequest)pce.getOldValue();
            if (newRequest == null) {
                this.noCurrentRequest();
            } else {
                this.currentRequestChanged(newRequest, oldRequest);
            }
        } else if (propName.equals("wsdlRequestContent")) {
            String newContent = (String)pce.getNewValue();
            String oldContent = (String)pce.getOldValue();
            if (newContent == null) {
                this.noCurrentRequestcontent();
            } else {
                this.currentRequestContentChanged(newContent, oldContent);
            }
        }
    }
}

