/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.target.subcomponent;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.iface.Interface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.JComboBox;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.main.testsuite.TestSuite;

public class InterfaceComboBox
extends JComboBox
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CONTROLLER = "controller";
    private ControllerInterface controller = null;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public InterfaceComboBox() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (InterfaceComboBox.this.controller != null && InterfaceComboBox.this.getSelectedIndex() >= 0) {
                    InterfaceComboBox.this.controller.setCurrentService(InterfaceComboBox.this.getSelectedIndex());
                }
            }
        });
    }

    public void currentInterfaceChanged(WsdlInterface newService, WsdlInterface oldService) {
        String name = newService.getName();
        this.setSelectedItem(name);
    }

    public void noCurrentInterface() {
    }

    public void wsdlChanged(TestSuite testSuite) {
        List<Interface> list = testSuite.getProject().getInterfaceList();
        this.removeAllItems();
        if (list != null) {
            for (Interface service : list) {
                String name = service.getName();
                this.addItem(name);
            }
        }
        if (this.getItemCount() > 0) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public ControllerInterface getController() {
        return this.controller;
    }

    public void setController(ControllerInterface controller) {
        TestSuite testSuite;
        ControllerInterface oldController = controller;
        this.controller = controller;
        if (oldController != null) {
            testSuite = oldController.getTestSuite();
            testSuite.getCurrentInterface().removePropertyChangeListener("wsdlInterface", this);
            testSuite.removePropertyChangeListener("project", this);
        }
        if (this.controller != null) {
            testSuite = oldController.getTestSuite();
            testSuite.getCurrentInterface().addPropertyChangeListener("wsdlInterface", this);
            testSuite.addPropertyChangeListener("project", this);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_CONTROLLER, oldController, controller);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if ("wsdlInterface".equals(propName)) {
            WsdlInterface newInterface = (WsdlInterface)pce.getNewValue();
            WsdlInterface oldInterface = (WsdlInterface)pce.getOldValue();
            if (newInterface == null) {
                this.noCurrentInterface();
            } else {
                this.currentInterfaceChanged(newInterface, oldInterface);
            }
        } else if ("project".equals(propName)) {
            WsdlProject project = (WsdlProject)pce.getNewValue();
            List<Interface> list = project.getInterfaceList();
            this.removeAllItems();
            if (list != null) {
                for (Interface service : list) {
                    String name = service.getName();
                    this.addItem(name);
                }
            }
            if (this.getItemCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

