/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.subcomponent;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import wsattacker.gui.component.pluginconfiguration.subcomponent.PluginTreeCellRenderer;
import wsattacker.gui.composition.AbstractTreeModel;
import wsattacker.gui.util.PluginCategory;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.PluginManagerListener;
import wsattacker.main.plugin.PluginManager;
import wsattacker.main.plugin.PluginState;
import wsattacker.util.Category;

public class PluginTreeModel
extends AbstractTreeModel
implements TreeModel,
PluginManagerListener {
    private static final Logger LOG = Logger.getLogger(PluginTreeCellRenderer.class);
    public static final String PROP_TREE = "tree";
    public static final String PROP_PLUGINMANAGER = "pluginManager";
    Category<String, AbstractPlugin> rootCategory;
    Category<String, AbstractPlugin> allCategory;
    Category<String, AbstractPlugin> activeCategory;
    Category<String, AbstractPlugin> abcCategory;
    private CheckboxTree tree = new CheckboxTree();
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PluginManager pluginManager;

    public PluginTreeModel() {
        this.rootCategory = new PluginCategory("root");
        this.allCategory = new PluginCategory("All Plugins");
        this.activeCategory = new PluginCategory("Active Plugins");
        this.abcCategory = new PluginCategory("Alphabetical Sorted");
        this.allCategory = this.rootCategory.addCategory(this.allCategory);
        this.activeCategory = this.rootCategory.addCategory(this.activeCategory);
        this.abcCategory = this.rootCategory.addCategory(this.abcCategory);
        this.setPluginManager(PluginManager.getInstance());
    }

    public CheckboxTree getTree() {
        return this.tree;
    }

    public void setTree(CheckboxTree tree) {
        CheckboxTree oldTree = this.tree;
        this.tree = tree;
        this.propertyChangeSupport.firePropertyChange(PROP_TREE, oldTree, tree);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void setPluginManager(PluginManager pluginManager) {
        PluginManager oldPluginManager = this.pluginManager;
        this.pluginManager = pluginManager;
        this.propertyChangeSupport.firePropertyChange(PROP_PLUGINMANAGER, oldPluginManager, pluginManager);
        if (oldPluginManager != null) {
            oldPluginManager.removeListener(this);
        }
        if (pluginManager != null) {
            pluginManager.addListener(this);
        }
        this.pluginContainerChanged();
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent.getClass().isAssignableFrom(this.rootCategory.getClass())) {
            return ((Category)parent).getNode(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object node) {
        int count = 0;
        if (node.getClass().isAssignableFrom(this.rootCategory.getClass())) {
            count = ((Category)node).countNodes();
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object parent, Object node) {
        int result = 0;
        if (parent.getClass().isAssignableFrom(this.rootCategory.getClass())) {
            result = ((Category)parent).getIndexOfNode(node);
        }
        return result;
    }

    @Override
    public Object getRoot() {
        return this.rootCategory;
    }

    @Override
    public boolean isLeaf(Object maybeLeaf) {
        return maybeLeaf instanceof AbstractPlugin;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        LOG.warn("### WARNING ###");
    }

    @Override
    public void currentPointsChanged(AbstractPlugin plugin, int newPoints) {
    }

    @Override
    public void pluginStateChanged(AbstractPlugin plugin, PluginState newState, PluginState oldState) {
        this.tree.repaint();
    }

    @Override
    public synchronized void pluginActiveStateChanged(AbstractPlugin plugin, boolean active) {
        LOG.debug("### Checked Pre:");
        for (TreePath x : this.tree.getCheckingPaths()) {
            LOG.debug("    " + x);
        }
        Category<String, AbstractPlugin> zwerg = this.allCategory;
        TreePath allPath = new TreePath(new Object[]{this.rootCategory, this.allCategory});
        for (String key : plugin.getCategory()) {
            if ((zwerg = zwerg.getSubCategory(key)) == null) {
                LOG.error("Error finding path");
                return;
            }
            allPath = allPath.pathByAddingChild(zwerg);
        }
        allPath = allPath.pathByAddingChild(plugin);
        TreePath activePath = new TreePath(new Object[]{this.rootCategory, this.activeCategory, plugin});
        TreePath abcPath = new TreePath(new Object[]{this.rootCategory, this.abcCategory, plugin});
        if (active) {
            if (this.activeCategory.addLeaf(plugin)) {
                this.fireChildAdded(activePath.getParentPath(), this.activeCategory.getIndexOfNode(plugin), plugin);
                this.tree.addCheckingPath(allPath);
                this.tree.addCheckingPath(activePath.getParentPath());
                this.tree.addCheckingPath(abcPath);
            }
        } else {
            int index = this.activeCategory.getIndexOfNode(plugin);
            if (this.activeCategory.removeLeaf(plugin)) {
                this.tree.removeCheckingPath(allPath);
                this.tree.removeCheckingPath(activePath);
                this.tree.removeCheckingPath(abcPath);
                this.fireChildRemoved(activePath.getParentPath(), index, plugin);
            }
        }
        LOG.debug("### Checked After:");
        for (TreePath x : this.tree.getCheckingPaths()) {
            LOG.debug(String.format("    %s %s", x, x.getLastPathComponent().getClass()));
        }
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            TreePath x = this.tree.getPathForRow(i);
            boolean checked = this.tree.getCheckingModel().isPathChecked(x);
            boolean enabled = this.tree.getCheckingModel().isPathEnabled(x);
            boolean greyed = this.tree.getCheckingModel().isPathGreyed(x);
            LOG.debug(x + (checked ? " (Checked)" : "") + (enabled ? " (Enabled)" : "") + (greyed ? " (Greyed)" : ""));
        }
    }

    @Override
    public synchronized void pluginContainerChanged() {
        this.allCategory.removeAllNodes(true);
        this.abcCategory.removeAllNodes(true);
        this.activeCategory.removeAllNodes(true);
        for (AbstractPlugin plugin : this.pluginManager) {
            this.allCategory.createPath((Comparable[])plugin.getCategory()).addLeaf(plugin);
            this.abcCategory.addLeaf(plugin);
        }
        this.fireNewRoot();
    }
}

