/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.option;

import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Validator;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionVarchar;
import wsattacker.main.plugin.option.OptionSimpleVarchar;

public class OptionVarcharGUI_NB
extends OptionGUI {
    private AbstractOptionVarchar option = new OptionSimpleVarchar("Sample Option", "Sample Description");
    public static final String PROP_OPTION = "option";
    private JLabel description;
    private JLabel maxLabel;
    private JLabel maxValue;
    private JLabel name;
    private JLabel typeLabel;
    private JLabel typeValue;
    private JTextField value;
    private BindingGroup bindingGroup;

    public BindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    public AbstractOptionVarchar getOption() {
        return this.option;
    }

    public void setOption(AbstractOptionVarchar option) {
        AbstractOptionVarchar oldOption = this.option;
        this.option = option;
        this.firePropertyChange(PROP_OPTION, oldOption, option);
    }

    public OptionVarcharGUI_NB() {
        this.initComponents();
    }

    public OptionVarcharGUI_NB(AbstractOptionVarchar option) {
        this.option = option;
        this.initComponents();
    }

    private void setValueBackgroundIfError(boolean error) {
        if (error) {
            this.value.setBackground(COLOR_ERROR);
        } else {
            this.value.setBackground(COLOR_OK);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.name = new JLabel();
        this.value = new JTextField();
        this.description = new JLabel();
        this.maxLabel = new JLabel();
        this.maxValue = new JLabel();
        this.typeLabel = new JLabel();
        this.typeValue = new JLabel();
        this.name.setFont(new Font("Dialog", 1, 18));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.name}"), this.name, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Name");
        binding.setSourceUnreadableValue("Option Name");
        this.bindingGroup.addBinding(binding);
        this.value.setColumns(this.option.getMaxLength());
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${option.value}"), this.value, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Value");
        binding.setSourceUnreadableValue("Option Value");
        binding.setValidator(new Validator<String>(){

            @Override
            public Validator.Result validate(String value) {
                Validator.Result result = null;
                if (!OptionVarcharGUI_NB.this.getOption().isValid(value)) {
                    result = new Validator.Result(this, 1, "Value invalid");
                    OptionVarcharGUI_NB.this.setValueBackgroundIfError(true);
                } else {
                    OptionVarcharGUI_NB.this.setValueBackgroundIfError(false);
                }
                return result;
            }
        });
        this.bindingGroup.addBinding(binding);
        this.description.setFont(new Font("Dialog", 0, 12));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.description}"), this.description, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Description");
        binding.setSourceUnreadableValue("Option Description");
        this.bindingGroup.addBinding(binding);
        this.maxLabel.setFont(new Font("Dialog", 0, 12));
        this.maxLabel.setText("Max Length:");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.maxLength}"), this.maxValue, BeanProperty.create("text"), this.option.getName());
        binding.setSourceNullValue("0");
        binding.setSourceUnreadableValue("0");
        binding.setConverter(new Converter<Integer, String>(){
            public static final String UNBOUND = "Unbound";

            @Override
            public String convertForward(Integer value) {
                String result = value <= 0 ? UNBOUND : String.format("%d", value);
                return result;
            }

            @Override
            public Integer convertReverse(String value) {
                int result = 0;
                if (!UNBOUND.equals(value)) {
                    try {
                        result = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        result = 0;
                    }
                }
                return result;
            }
        });
        this.bindingGroup.addBinding(binding);
        this.typeLabel.setFont(new Font("Dialog", 0, 12));
        this.typeLabel.setText("Type:");
        this.typeValue.setText("Text");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.value).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name).addComponent(this.description).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxValue))).addGap(0, 212, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.name).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.value, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxLabel).addComponent(this.maxValue).addComponent(this.typeLabel).addComponent(this.typeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.description).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    @Override
    public void bindingDoUnbind() {
        this.bindingGroup.unbind();
    }

    @Override
    public AbstractOption getUsedOption() {
        return this.option;
    }
}

