/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.option;

import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Validator;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionString;
import wsattacker.main.plugin.option.OptionSimpleText;

public class OptionStringGUI_NB
extends OptionGUI {
    private AbstractOptionString option = new OptionSimpleText("Sample Option", "Sample Description");
    public static final String PROP_OPTION = "option";
    private JLabel description;
    private JLabel jLabel1;
    private JLabel lengthLabel;
    private JLabel maxValue;
    private JLabel name;
    private JLabel typeLabel;
    private JTextPane value;
    private JScrollPane valueScrollPane;
    private BindingGroup bindingGroup;

    public AbstractOptionString getOption() {
        return this.option;
    }

    public void setOption(AbstractOptionString option) {
        AbstractOptionString oldOption = this.option;
        this.option = option;
        this.firePropertyChange(PROP_OPTION, oldOption, option);
    }

    public OptionStringGUI_NB() {
        this.initComponents();
    }

    public OptionStringGUI_NB(AbstractOptionString option) {
        this.option = option;
        this.initComponents();
    }

    private void setValueBackgroundIfError(boolean error) {
        if (error) {
            this.value.setBackground(COLOR_ERROR);
        } else {
            this.value.setBackground(COLOR_OK);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.name = new JLabel();
        this.description = new JLabel();
        this.lengthLabel = new JLabel();
        this.maxValue = new JLabel();
        this.valueScrollPane = new JScrollPane();
        this.value = new JTextPane();
        this.typeLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.name.setFont(new Font("Dialog", 1, 18));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.name}"), this.name, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Name");
        binding.setSourceUnreadableValue("Option Name");
        this.bindingGroup.addBinding(binding);
        this.description.setFont(new Font("Dialog", 0, 12));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.description}"), this.description, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Description");
        binding.setSourceUnreadableValue("Option Description");
        this.bindingGroup.addBinding(binding);
        this.lengthLabel.setFont(new Font("Dialog", 0, 12));
        this.lengthLabel.setText("Length:");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.value, ELProperty.create("${text}"), this.maxValue, BeanProperty.create("text"), this.option.getName());
        binding.setSourceNullValue("0");
        binding.setSourceUnreadableValue("0");
        binding.setConverter(new Converter<String, String>(){

            @Override
            public String convertForward(String value) {
                return String.format("%d", value.length());
            }

            @Override
            public String convertReverse(String value) {
                return "### Read Only ###";
            }
        });
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${option.value}"), this.value, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Value");
        binding.setSourceUnreadableValue("Option Value");
        binding.setValidator(new Validator<String>(){

            @Override
            public Validator.Result validate(String value) {
                Validator.Result result = null;
                if (!OptionStringGUI_NB.this.getOption().isValid(value)) {
                    result = new Validator.Result(this, 1, "Value invalid");
                    OptionStringGUI_NB.this.setValueBackgroundIfError(true);
                } else {
                    OptionStringGUI_NB.this.setValueBackgroundIfError(false);
                }
                return result;
            }
        });
        this.bindingGroup.addBinding(binding);
        this.valueScrollPane.setViewportView(this.value);
        this.typeLabel.setFont(new Font("Dialog", 0, 12));
        this.typeLabel.setText("Type:");
        this.jLabel1.setText("Text");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name).addComponent(this.description).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lengthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxValue))).addGap(0, 156, Short.MAX_VALUE)).addComponent(this.valueScrollPane)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.name).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueScrollPane, -2, 141, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lengthLabel).addComponent(this.maxValue).addComponent(this.typeLabel).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.description).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    @Override
    public void bindingDoUnbind() {
        this.bindingGroup.unbind();
    }

    @Override
    public AbstractOption getUsedOption() {
        return this.option;
    }
}

