/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.option;

import java.awt.Font;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.SwingBindings;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionChoice;
import wsattacker.main.plugin.option.OptionSimpleChoice;

public class OptionChoiceGUI_NB
extends OptionGUI {
    private final List<String> FALLBACKCHOICES = Arrays.asList("Currently no Data");
    private AbstractOptionChoice option = new OptionSimpleChoice("Sample Option", Collections.emptyList(), 0, "Sample Description");
    public static final String PROP_OPTION = "option";
    private JComboBox choices;
    private JLabel description;
    private JLabel name;
    private BindingGroup bindingGroup;

    public AbstractOptionChoice getOption() {
        return this.option;
    }

    public void setOption(AbstractOptionChoice option) {
        AbstractOptionChoice oldOptionChoice = this.option;
        this.option = option;
        this.firePropertyChange(PROP_OPTION, oldOptionChoice, option);
    }

    public OptionChoiceGUI_NB() {
        this.initComponents();
    }

    public OptionChoiceGUI_NB(AbstractOptionChoice option) {
        this.option = option;
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.name = new JLabel();
        this.choices = new JComboBox();
        this.description = new JLabel();
        this.name.setFont(new Font("Dialog", 1, 18));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.name}"), this.name, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Name");
        binding.setSourceUnreadableValue("Option Name");
        this.bindingGroup.addBinding(binding);
        this.choices.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        ELProperty eLProperty = ELProperty.create("${option.choices}");
        JComboBoxBinding jComboBoxBinding = SwingBindings.createJComboBoxBinding(AutoBinding.UpdateStrategy.READ, this, eLProperty, this.choices);
        jComboBoxBinding.setSourceNullValue(this.FALLBACKCHOICES);
        jComboBoxBinding.setSourceUnreadableValue(this.FALLBACKCHOICES);
        this.bindingGroup.addBinding(jComboBoxBinding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${option.selectedAsString}"), this.choices, BeanProperty.create("selectedItem"));
        binding.setValidator(new Validator<String>(){

            @Override
            public Validator.Result validate(String value) {
                Validator.Result result = null;
                if (!OptionChoiceGUI_NB.this.getOption().isValid(value)) {
                    result = new Validator.Result(this, 1, "Value invalid");
                    OptionChoiceGUI_NB.this.setValueBackgroundIfError(true);
                } else {
                    OptionChoiceGUI_NB.this.setValueBackgroundIfError(false);
                }
                return result;
            }
        });
        this.bindingGroup.addBinding(binding);
        this.description.setFont(new Font("Dialog", 0, 12));
        this.description.setVerticalAlignment(1);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.description}"), this.description, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Description");
        binding.setSourceUnreadableValue("Option Description");
        this.bindingGroup.addBinding(binding);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.description, -1, -1, Short.MAX_VALUE).addComponent(this.choices, 0, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.name, -1, -1, Short.MAX_VALUE).addGap(388, 388, 388)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.name).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.choices, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.description).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void setValueBackgroundIfError(boolean error) {
        if (error) {
            this.choices.setBackground(COLOR_ERROR);
        } else {
            this.choices.setBackground(COLOR_OK);
        }
    }

    @Override
    public void bindingDoUnbind() {
        List<Binding> bindingList = this.bindingGroup.getBindings();
        for (int i = bindingList.size() - 1; i >= 0; --i) {
            bindingList.get(i).unbind();
        }
    }

    @Override
    public AbstractOption getUsedOption() {
        return this.option;
    }
}

