/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import wsattacker.gui.component.pluginconfiguration.controller.PluginConfigurationController;
import wsattacker.gui.component.pluginconfiguration.subcomponent.PluginTreeCellRenderer;
import wsattacker.gui.component.pluginconfiguration.subcomponent.PluginTreeModel;
import wsattacker.gui.component.pluginconfiguration.subcomponent.SelectedPlugin;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.util.Category;

public class PluginConfigurationGUI_NB
extends JPanel {
    private static final Logger LOG = Logger.getLogger(PluginConfigurationGUI_NB.class);
    private PluginConfigurationController pluginConfigurationController;
    private CheckboxTree pluginTree;
    private PluginTreeCellRenderer pluginTreeCellRenderer;
    private PluginTreeModel pluginTreeModel;
    private JScrollPane pluginTreeScrollPane;
    private JPanel rightPanel;
    private SelectedPlugin selectedPlugin;
    private JSplitPane splitPane;
    private JScrollPane treeScrollPane;
    private BindingGroup bindingGroup;

    public PluginConfigurationGUI_NB() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.pluginConfigurationController = new PluginConfigurationController();
        this.pluginTreeCellRenderer = new PluginTreeCellRenderer();
        this.pluginTreeModel = new PluginTreeModel();
        this.splitPane = new JSplitPane();
        this.pluginTreeScrollPane = new JScrollPane();
        this.pluginTree = new CheckboxTree();
        this.rightPanel = new JPanel();
        this.selectedPlugin = new SelectedPlugin();
        this.pluginTreeModel.setTree(this.pluginTree);
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.pluginConfigurationController, ELProperty.create("${pluginManager}"), this.pluginTreeModel, BeanProperty.create("pluginManager"));
        this.bindingGroup.addBinding(binding);
        this.setName("Plugin Configuration");
        this.splitPane.setDividerSize(1);
        this.splitPane.setEnabled(false);
        this.pluginTree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_CHECK);
        this.pluginTree.getSelectionModel().setSelectionMode(1);
        this.pluginTree.setBackground(new Color(238, 238, 238));
        this.pluginTree.setModel(this.pluginTreeModel);
        this.pluginTree.setCellRenderer(this.pluginTreeCellRenderer);
        this.pluginTree.setRootVisible(false);
        this.pluginTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                PluginConfigurationGUI_NB.this.pluginTreeTreeExpanded(evt);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                PluginConfigurationGUI_NB.this.pluginTreeTreeCollapsed(evt);
            }
        });
        this.pluginTree.addTreeCheckingListener(new TreeCheckingListener(){

            @Override
            public void valueChanged(TreeCheckingEvent evt) {
                PluginConfigurationGUI_NB.this.pluginTreeValueChanged(evt);
            }
        });
        this.pluginTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PluginConfigurationGUI_NB.this.pluginTreeValueChanged1(evt);
            }
        });
        this.pluginTreeScrollPane.setViewportView(this.pluginTree);
        this.splitPane.setLeftComponent(this.pluginTreeScrollPane);
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.add((Component)this.selectedPlugin, "Center");
        this.splitPane.setRightComponent(this.rightPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, -1, 618, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, -1, 421, Short.MAX_VALUE));
        this.bindingGroup.bind();
    }

    private void pluginTreeValueChanged1(TreeSelectionEvent evt) {
        Object lastComponent = evt.getPath().getLastPathComponent();
        AbstractPlugin selected = null;
        if (lastComponent instanceof AbstractPlugin) {
            selected = (AbstractPlugin)lastComponent;
        }
        this.selectedPlugin.getSelectedPluginController().setSelectedPlugin(selected);
    }

    private void pluginTreeValueChanged(TreeCheckingEvent evt) {
        Object o = evt.getPath().getLastPathComponent();
        if (o instanceof AbstractPlugin) {
            this.pluginConfigurationController.getController().setPluginActive(((AbstractPlugin)o).getName(), evt.isCheckedPath());
        } else if (o.getClass().isAssignableFrom(this.pluginTree.getModel().getRoot().getClass())) {
            Object node = this.pluginTree.getModel().getRoot();
            Object[] path = evt.getPath().getPath();
            for (int i = 1; i < path.length; ++i) {
                node = this.pluginTree.getModel().getChild(node, this.pluginTree.getModel().getIndexOfChild(node, path[i]));
            }
            if (node instanceof Category) {
                Category category = (Category)node;
                List list = category.getLeafsRecursive();
                for (AbstractPlugin plugin : list) {
                    this.pluginConfigurationController.getController().setPluginActive(plugin.getName(), evt.isCheckedPath());
                }
            }
        }
        this.repaint();
    }

    private void pluginTreeTreeCollapsed(TreeExpansionEvent evt) {
        int pos = this.pluginTree.getPreferredSize().width + 5;
        this.splitPane.setDividerLocation(pos);
    }

    private void pluginTreeTreeExpanded(TreeExpansionEvent evt) {
        int pos = this.pluginTree.getPreferredSize().width + 5;
        this.splitPane.setDividerLocation(pos);
    }

    public PluginConfigurationController getController() {
        return this.pluginConfigurationController;
    }
}

