/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.expertview;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.panels.iface.WsdlInterfacePanelBuilder;
import com.eviware.soapui.impl.wsdl.panels.operation.WsdlOperationPanelBuilder;
import com.eviware.soapui.impl.wsdl.panels.request.WsdlRequestPanelBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import wsattacker.main.testsuite.TestSuite;

public class ExpertView
implements PropertyChangeListener {
    Component servicePanel;
    Component operationPanel;
    Component requestPanel;
    JPanel panel;
    WsdlInterfacePanelBuilder serviceBuilder = new WsdlInterfacePanelBuilder();
    WsdlOperationPanelBuilder operationBuilder = new WsdlOperationPanelBuilder();
    WsdlRequestPanelBuilder requestBuilder = new WsdlRequestPanelBuilder();

    public ExpertView(TestSuite testSuite) {
        this.panel = new JPanel();
        GridBagLayout panelLayout = new GridBagLayout();
        panelLayout.rowWeights = new double[]{0.2, 0.2, 0.6};
        panelLayout.rowHeights = new int[]{99, 98, 7};
        panelLayout.columnWeights = new double[]{0.1};
        panelLayout.columnWidths = new int[]{7};
        this.panel.setLayout(panelLayout);
        this.panel.setName("Expert View");
        this.panel.setPreferredSize(new Dimension(368, 374));
        testSuite.getCurrentInterface().addPropertyChangeListener("wsdlInterface", this);
        testSuite.getCurrentOperation().addPropertyChangeListener("wsdlOperation", this);
        testSuite.getCurrentRequest().addPropertyChangeListener("wsdlRequest", this);
    }

    public Component getView() {
        return this.panel;
    }

    public void currentRequestChanged(WsdlRequest newRequest, WsdlRequest oldRequest) {
        if (this.requestPanel != null && SwingUtilities.isDescendingFrom(this.requestPanel, this.panel)) {
            this.panel.remove(this.requestPanel);
        }
        this.requestPanel = this.requestBuilder.buildOverviewPanel(newRequest);
        this.panel.add(this.requestPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void noCurrentRequest() {
        if (this.requestPanel != null && SwingUtilities.isDescendingFrom(this.requestPanel, this.panel)) {
            this.panel.remove(this.requestPanel);
        }
    }

    public void currentOperationChanged(WsdlOperation newOperation, WsdlOperation oldOperation) {
        if (this.operationPanel != null && SwingUtilities.isDescendingFrom(this.operationPanel, this.panel)) {
            this.panel.remove(this.operationPanel);
        }
        this.operationPanel = this.operationBuilder.buildOverviewPanel(newOperation);
        this.panel.add(this.operationPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void noCurrentOperation() {
        if (this.operationPanel != null && SwingUtilities.isDescendingFrom(this.operationPanel, this.panel)) {
            this.panel.remove(this.operationPanel);
        }
    }

    public void currentInterfaceChanged(WsdlInterface newService, WsdlInterface oldService) {
        if (this.servicePanel != null && SwingUtilities.isDescendingFrom(this.servicePanel, this.panel)) {
            this.panel.remove(this.servicePanel);
        }
        this.servicePanel = this.serviceBuilder.buildOverviewPanel(newService);
        this.panel.add(this.servicePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void noCurrentInterface() {
        if (this.servicePanel != null && SwingUtilities.isDescendingFrom(this.servicePanel, this.panel)) {
            this.panel.remove(this.servicePanel);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if (propName.equals("wsdlRequest")) {
            WsdlRequest newRequest = (WsdlRequest)pce.getNewValue();
            WsdlRequest oldRequest = (WsdlRequest)pce.getOldValue();
            if (newRequest == null) {
                this.noCurrentRequest();
            } else {
                this.currentRequestChanged(newRequest, oldRequest);
            }
        } else if ("wsdlInterface".equals(propName)) {
            WsdlInterface newInterface = (WsdlInterface)pce.getNewValue();
            WsdlInterface oldInterface = (WsdlInterface)pce.getOldValue();
            if (newInterface == null) {
                this.noCurrentInterface();
            } else {
                this.currentInterfaceChanged(newInterface, oldInterface);
            }
        } else if ("wsdlOperation".equals(propName)) {
            WsdlOperation newOperation = (WsdlOperation)pce.getNewValue();
            WsdlOperation oldOperation = (WsdlOperation)pce.getOldValue();
            this.currentOperationChanged(newOperation, oldOperation);
        }
    }
}

