/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.attackoverview.subcomponent;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.PluginFunctionInterface;
import wsattacker.main.plugin.PluginManager;

class EnabledPluginTablePopup
extends JPopupMenu {
    public EnabledPluginTablePopup() {
        this.addPopupMenuListener(new PopupMenuListener(){

            private void maybeUpdateSelection(PopupMenuEvent e) {
                MouseEvent me;
                AWTEvent awtEvent = EventQueue.getCurrentEvent();
                if (!(awtEvent instanceof MouseEvent) || !(me = (MouseEvent)awtEvent).isPopupTrigger()) {
                    return;
                }
                JPopupMenu menu = (JPopupMenu)e.getSource();
                Component invoker = menu.getInvoker();
                if (!(invoker instanceof JTable)) {
                    return;
                }
                JTable table = (JTable)invoker;
                Point p = me.getPoint();
                int row = table.rowAtPoint(p);
                int col = table.columnAtPoint(p);
                if (row == -1 || col == -1) {
                    return;
                }
                EnabledPluginTablePopup.this.removeAll();
                AbstractPlugin plugin = PluginManager.getInstance().getActive(row);
                EnabledPluginTablePopup.this.add(new JMenuItem(plugin.getName()));
                EnabledPluginTablePopup.this.add(new JSeparator());
                if (plugin.getPluginFunctions().length == 0) {
                    JMenuItem item = new JMenuItem("- No additional functions -");
                    item.setEnabled(false);
                    EnabledPluginTablePopup.this.add(item);
                }
                for (PluginFunctionInterface function : plugin.getPluginFunctions()) {
                    if (function == null) continue;
                    JMenuItem item = new JMenuItem(function.getName());
                    item.addActionListener(new ActionListenerHelper(function));
                    item.setEnabled(function.isEnabled());
                    EnabledPluginTablePopup.this.add(item);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.maybeUpdateSelection(e);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.maybeUpdateSelection(e);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.maybeUpdateSelection(e);
            }
        });
    }

    class ActionListenerHelper
    implements ActionListener {
        private final PluginFunctionInterface function;

        public ActionListenerHelper(PluginFunctionInterface function) {
            this.function = function;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.function.getGuiWindow().setVisible(true);
        }
    }
}

