/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.attackoverview.subcomponent;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import wsattacker.gui.component.attackoverview.subcomponent.EnabledPluginTablePopup;
import wsattacker.gui.util.CenteredTableCellRenderer;
import wsattacker.gui.util.ColoredPluginStateTableCellRenderer;
import wsattacker.gui.util.VulnerableTableCellRenderer;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.PluginManagerListener;
import wsattacker.main.plugin.PluginManager;
import wsattacker.main.plugin.PluginState;

public class EnabledPluginTable
extends JTable {
    public EnabledPluginTable() {
        this.setModel(new AttackOverviewTableModel());
        this.getColumnModel().getColumn(0).setCellRenderer(new CenteredTableCellRenderer());
        this.getColumnModel().getColumn(1).setCellRenderer(new ColoredPluginStateTableCellRenderer());
        this.getColumnModel().getColumn(2).setCellRenderer(new CenteredTableCellRenderer());
        this.getColumnModel().getColumn(3).setCellRenderer(new VulnerableTableCellRenderer());
        this.setComponentPopupMenu(new EnabledPluginTablePopup());
    }

    public class AttackOverviewTableModel
    extends AbstractTableModel
    implements PluginManagerListener {
        private final String[] columnNames = new String[]{"Name", "Status", "Rating", "Vulnerable?"};
        final PluginManager pluginManager = PluginManager.getInstance();

        public AttackOverviewTableModel() {
            this.pluginManager.addListener(this);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int num) {
            return this.columnNames[num];
        }

        @Override
        public boolean isCellEditable(int y, int x) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.pluginManager.countActivePlugins();
        }

        @Override
        public Object getValueAt(int row, int col) {
            AbstractPlugin plugin = this.pluginManager.getActive(row);
            switch (col) {
                case 0: {
                    return plugin.getName();
                }
                case 1: {
                    return plugin.getState();
                }
                case 2: {
                    return String.format("%d%%", 100 * plugin.getCurrentPoints() / plugin.getMaxPoints());
                }
                case 3: {
                    return new Boolean(plugin.wasSuccessful());
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void currentPointsChanged(AbstractPlugin plugin, int newPoints) {
            if (this.pluginManager.isActive(plugin)) {
                int row = this.pluginManager.indexOfActive(plugin);
                this.fireTableCellUpdated(row, 2);
            }
        }

        @Override
        public void pluginStateChanged(AbstractPlugin plugin, PluginState newState, PluginState oldState) {
            if (this.pluginManager.isActive(plugin)) {
                int row = this.pluginManager.indexOfActive(plugin);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 3);
            }
        }

        @Override
        public void pluginActiveStateChanged(AbstractPlugin plugin, boolean active) {
            if (active) {
                int row = this.pluginManager.indexOf(plugin);
                this.fireTableRowsInserted(row, row);
            } else {
                this.fireTableDataChanged();
            }
        }

        @Override
        public void pluginContainerChanged() {
            this.fireTableDataChanged();
        }
    }
}

