/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.attackoverview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import wsattacker.gui.component.attackoverview.subcomponent.ResultTable;
import wsattacker.gui.util.CenteredTableCellRenderer;
import wsattacker.gui.util.ColoredPluginStateTableCellRenderer;
import wsattacker.gui.util.VulnerableTableCellRenderer;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.PluginManagerListener;
import wsattacker.main.plugin.PluginState;
import wsattacker.main.plugin.result.ResultLevel;

public class AttackOverview
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable pluginTable;
    private JScrollPane pluginTableScrollPane;
    private ResultTable resultTable;
    private JSlider resultLevelSlider;
    private JButton stop;
    private JSplitPane splitPane;
    private AbstractAction cleanResultsAction;
    private JButton clean;
    private JScrollPane resultsScrollPane;
    private AbstractAction stopAttackAction;
    private AbstractAction startAttackAction;
    private JButton start;
    private final ControllerInterface controller;

    public AttackOverview(ControllerInterface controller) {
        this.controller = controller;
        this.setName("Attack Overview");
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.getJSplitPane1();
            GroupLayout thisLayout = new GroupLayout(this);
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(868, 346));
            this.start = new JButton();
            this.start.setText("Start Attack");
            this.start.setAction(this.getStartAttackAction());
            this.stop = new JButton();
            this.stop.setText("Stop Attack");
            this.stop.setAction(this.getStopAttackAction());
            thisLayout.setVerticalGroup(thisLayout.createSequentialGroup().addContainerGap().addGroup(thisLayout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, thisLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.start, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.stop, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.getClean(), GroupLayout.Alignment.BASELINE, -2, -2, -2)).addComponent(this.getResultLevelSlider(), GroupLayout.Alignment.LEADING, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getJSplitPane1(), 0, 281, Short.MAX_VALUE).addContainerGap());
            thisLayout.setHorizontalGroup(thisLayout.createSequentialGroup().addContainerGap().addGroup(thisLayout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, thisLayout.createSequentialGroup().addComponent(this.start, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stop, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getClean(), -2, 149, -2).addGap(0, 66, Short.MAX_VALUE).addComponent(this.getResultLevelSlider(), -2, 309, -2)).addComponent(this.getJSplitPane1(), GroupLayout.Alignment.LEADING, 0, 844, Short.MAX_VALUE)).addContainerGap());
            thisLayout.linkSize(1, this.stop, this.start);
            thisLayout.linkSize(0, this.getClean(), this.stop, this.start);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JTable getPluginTable() {
        return this.pluginTable;
    }

    private AbstractAction getStartAttackAction() {
        if (this.startAttackAction == null) {
            this.startAttackAction = new AbstractAction("Start Attack", null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AttackOverview.this.controller.startActivePlugins();
                }
            };
        }
        return this.startAttackAction;
    }

    private AbstractAction getStopAttackAction() {
        if (this.stopAttackAction == null) {
            this.stopAttackAction = new AbstractAction("Stop Attack", null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AttackOverview.this.controller.stopActivePlugins();
                }
            };
        }
        return this.stopAttackAction;
    }

    private JButton getClean() {
        if (this.clean == null) {
            this.clean = new JButton();
            this.clean.setText("Clean Results");
            this.clean.setAction(this.getCleanResultsAction());
        }
        return this.clean;
    }

    private AbstractAction getCleanResultsAction() {
        if (this.cleanResultsAction == null) {
            this.cleanResultsAction = new AbstractAction("Clean Results", null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AttackOverview.this.controller.cleanPlugins();
                }
            };
        }
        return this.cleanResultsAction;
    }

    private JSlider getResultLevelSlider() {
        if (this.resultLevelSlider == null) {
            this.resultLevelSlider = new JSlider();
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            ResultLevel[] levels = ResultLevel.values();
            int max = levels.length - 1;
            this.resultLevelSlider.setMinimum(0);
            this.resultLevelSlider.setMaximum(max);
            for (int i = max; i >= 0; --i) {
                ((Dictionary)labelTable).put(i, new JLabel(levels[i].toString()));
            }
            this.resultLevelSlider.setLabelTable(labelTable);
            this.resultLevelSlider.setPaintLabels(true);
            this.resultLevelSlider.setSnapToTicks(true);
            this.resultLevelSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int val = AttackOverview.this.resultLevelSlider.getValue();
                    String level = ((JLabel)AttackOverview.this.resultLevelSlider.getLabelTable().get(val)).getText();
                    AttackOverview.this.resultTable.setLevel(ResultLevel.valueOf(level));
                }
            });
            this.resultLevelSlider.setValue(max / 2);
        }
        return this.resultLevelSlider;
    }

    private JSplitPane getJSplitPane1() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setOrientation(0);
            this.pluginTableScrollPane = new JScrollPane();
            this.splitPane.add((Component)this.pluginTableScrollPane, "top");
            this.pluginTable = new JTable();
            this.pluginTableScrollPane.setViewportView(this.pluginTable);
            this.pluginTable.setModel(new AttackOverviewTableModel());
            this.pluginTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int[] selected = AttackOverview.this.pluginTable.getSelectedRows();
                        ArrayList<String> sources = new ArrayList<String>();
                        for (int index : selected) {
                            sources.add(AttackOverview.this.controller.getPluginManager().getActive(index).getName());
                        }
                        AttackOverview.this.resultTable.filterSources(sources);
                    }
                }
            });
            this.pluginTable.getColumnModel().getColumn(0).setCellRenderer(new CenteredTableCellRenderer());
            this.pluginTable.getColumnModel().getColumn(1).setCellRenderer(new ColoredPluginStateTableCellRenderer());
            this.pluginTable.getColumnModel().getColumn(2).setCellRenderer(new CenteredTableCellRenderer());
            this.pluginTable.getColumnModel().getColumn(3).setCellRenderer(new CenteredTableCellRenderer());
            this.pluginTable.getColumnModel().getColumn(4).setCellRenderer(new VulnerableTableCellRenderer());
            this.resultsScrollPane = new JScrollPane();
            this.splitPane.add((Component)this.resultsScrollPane, "bottom");
            this.resultTable = new ResultTable();
            this.resultsScrollPane.setViewportView(this.resultTable);
        }
        return this.splitPane;
    }

    public class AttackOverviewTableModel
    extends AbstractTableModel
    implements PluginManagerListener {
        private final String[] columnNames = new String[]{"Name", "Status", "Current", "Max", "Vulnerable?"};

        public AttackOverviewTableModel() {
            AttackOverview.this.controller.getPluginManager().addListener(this);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int num) {
            return this.columnNames[num];
        }

        @Override
        public boolean isCellEditable(int y, int x) {
            return false;
        }

        @Override
        public int getRowCount() {
            return AttackOverview.this.controller.getPluginManager().countActivePlugins();
        }

        @Override
        public Object getValueAt(int row, int col) {
            AbstractPlugin plugin = AttackOverview.this.controller.getPluginManager().getActive(row);
            switch (col) {
                case 0: {
                    return plugin.getName();
                }
                case 1: {
                    return plugin.getState();
                }
                case 2: {
                    return new Integer(plugin.getCurrentPoints());
                }
                case 3: {
                    return new Integer(plugin.getMaxPoints());
                }
                case 4: {
                    return new Boolean(plugin.wasSuccessful());
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void currentPointsChanged(AbstractPlugin plugin, int newPoints) {
            int row = AttackOverview.this.controller.getPluginManager().indexOfActive(plugin);
            this.fireTableCellUpdated(row, 2);
        }

        @Override
        public void pluginStateChanged(AbstractPlugin plugin, PluginState newState, PluginState oldState) {
            if (AttackOverview.this.controller.getPluginManager().isActive(plugin)) {
                int row = AttackOverview.this.controller.getPluginManager().indexOfActive(plugin);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 4);
            }
        }

        @Override
        public void pluginActiveStateChanged(AbstractPlugin plugin, boolean active) {
            if (active) {
                int row = AttackOverview.this.controller.getPluginManager().indexOf(plugin);
                this.fireTableRowsInserted(row, row);
            } else {
                this.fireTableDataChanged();
            }
        }

        @Override
        public void pluginContainerChanged() {
            this.fireTableDataChanged();
        }
    }
}

