/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui;

import com.eviware.x.form.XFormFactory;
import com.eviware.x.impl.swing.SwingFormFactory;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.apache.log4j.Logger;
import wsattacker.gui.component.MainWindow;
import wsattacker.gui.component.attackoverview.AttackOverview_NB;
import wsattacker.gui.component.config.Configuration;
import wsattacker.gui.component.expertview.ExpertView;
import wsattacker.gui.component.log.GuiAppender;
import wsattacker.gui.component.pluginconfiguration.PluginConfigurationGUI_NB;
import wsattacker.gui.component.target.WsdlLoaderGUI_NB;
import wsattacker.gui.component.testrequest.RequestResponseGUI_NB;
import wsattacker.main.Preferences;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.persistence.XmlPersistenceError;

public class GuiView
implements Runnable {
    private static final Logger LOG = Logger.getLogger(GuiView.class);
    ControllerInterface controller;
    WsdlLoaderGUI_NB wsdlLoader;
    MainWindow mainWindow;
    PluginConfigurationGUI_NB pluginConfig;
    AttackOverview_NB attack;
    ExpertView expertView;

    GuiView(ControllerInterface controller) {
        this.controller = controller;
    }

    public void createView() {
        this.mainWindow = new MainWindow();
        this.mainWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                try {
                    Preferences.saveToDisk();
                }
                catch (XmlPersistenceError ex) {
                    LOG.warn(ex.getMessage());
                }
            }
        });
        this.wsdlLoader = new WsdlLoaderGUI_NB();
        this.wsdlLoader.setController(this.controller);
        this.mainWindow.getTabs().add(this.wsdlLoader);
        this.mainWindow.getTabs().add(new RequestResponseGUI_NB());
        this.pluginConfig = new PluginConfigurationGUI_NB();
        this.pluginConfig.getController().setController(this.controller);
        this.mainWindow.getTabs().add(this.pluginConfig);
        this.attack = new AttackOverview_NB(this.controller);
        this.mainWindow.getTabs().add(this.attack);
        this.mainWindow.getTabs().add(GuiAppender.getLog());
        this.mainWindow.setDefaultCloseOperation(3);
        this.mainWindow.pack();
        this.mainWindow.setVisible(true);
        this.expertView = new ExpertView(this.controller.getTestSuite());
        this.mainWindow.getTabs().add(this.expertView.getView());
        Configuration configuration = new Configuration();
        this.mainWindow.getTabs().add(configuration);
        XFormFactory.Factory.instance = new SwingFormFactory();
    }

    public WsdlLoaderGUI_NB getWsdlLoader() {
        return this.wsdlLoader;
    }

    public MainWindow getMainWindows() {
        return this.mainWindow;
    }

    public AttackOverview_NB getAttackOverview() {
        return this.attack;
    }

    @Override
    public void run() {
        this.createView();
    }
}

