/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.xmlencryptionattack;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.xmlencryptionattack.attackengine.AttackConfig;
import wsattacker.library.xmlencryptionattack.attackengine.AttackManager;
import wsattacker.library.xmlencryptionattack.attackengine.CryptoAttackException;
import wsattacker.library.xmlencryptionattack.attackengine.Utility;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.AOracle;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.FactoryFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete.AvoidedDocErrorFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AbstractDetectionInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.util.HelperFunctions;
import wsattacker.library.xmlencryptionattack.util.XMLEncryptionConstants;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.plugin.PluginState;
import wsattacker.main.testsuite.TestSuite;
import wsattacker.plugin.xmlencryptionattack.WebServiceSendCommand;
import wsattacker.plugin.xmlencryptionattack.option.OptionManagerEncryption;

public class XMLEncryptionAttack
extends AbstractPlugin {
    private static final Logger LOG;
    private static final String NAME = "XML Encryption Attack";
    private static final String DESCRIPTION = "<html><p>Contains adaptive chosen ciphertext attacks on XML Encryption. Currently supported techniques:</p><ul><li>Attack on CBC Ciphertexts.</li><li>Attack on RSA-PKCS#1 Ciphertexts using direct error messages.</li><li>Attack on RSA-PKCS#1 Ciphertexts using a CBC weakness.</li></ul><p>To overcome XML Signature protection, XML Signature and XML Encryption Wrapping attacks are implemented.</p></html>";
    private static final String AUTHOR = "Dennis Kupser";
    private static final String VERSION = "1.0 / 2015-05-08";
    private static final String[] CATEGORY;
    private static SchemaAnalyzer m_SchemaAnalyser;
    private static SchemaAnalyzer m_UsedSchemaAnalyser;
    private AttackConfig m_AttackCfg = null;
    private AvoidedDocErrorFilter m_AvoiDocErrFilter = null;
    private OptionManagerEncryption m_OptionManager = null;
    private final int m_SuccessThreashold = 100;

    public void initializePlugin() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
        this.setAuthor(AUTHOR);
        this.setVersion(VERSION);
        this.setCategory(CATEGORY);
        throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.schemaanalyzer.SchemaAnalyzer");
    }

    public void clean() {
        this.setCurrentPoints(0);
        this.checkState();
    }

    public boolean wasSuccessful() {
        return this.isFinished() && this.getCurrentPoints() >= 100;
    }

    protected void attackImplementationHook(RequestResponsePair original) {
        DetectionReport detectReport = this.m_OptionManager.getDetectReport();
        if (null == this.m_AttackCfg.getChosenAttackPayload()) {
            throw new IllegalArgumentException("user has to choose an attack payload");
        }
        if (null == detectReport.getDetectionInfo(DetectFilterEnum.AVOIDDOCFILTER)) {
            throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException");
        }
        if (null != detectReport.getDetectionInfo(DetectFilterEnum.AVOIDDOCFILTER)) {
            this.setCurrentPoints(50);
            try {
                this.handleEncryptionAttack(detectReport);
            }
            catch (UnsupportedEncodingException | IllegalArgumentException ex) {
                LOG.error((Object)ex);
            }
        } else {
            this.info("XML Encryption attack is not possible");
        }
    }

    public void getAvoidedAttackRequest(DetectionReport detectReport) throws InvalidWeaknessException, InvalidPayloadException, SAXException, XPathExpressionException {
        throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException");
    }

    private void setAvoidedDocWithAvoidingManager(DetectionReport detectReport, WebServiceSendCommand serSendCmnd) throws InvalidWeaknessException, InvalidPayloadException, XPathExpressionException, SAXException {
        throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException");
    }

    private void setAvoidedDocWithoutWrapping(DetectionReport detectReport) {
        this.important("Setting avoided Document");
        AbstractDetectionInfo errorInfo = null;
        this.m_AvoiDocErrFilter.setPayloadInput(this.m_AttackCfg.getChosenAttackPayload());
        AbstractEncryptionElement tempPayElement = this.m_AvoiDocErrFilter.getPayloadInput();
        ElementAttackProperties attackPropsPay = tempPayElement.getAttackProperties();
        this.m_AvoiDocErrFilter.setInputDocument(detectReport.getRawFile());
        attackPropsPay.setAttackPayloadElement(this.m_AvoiDocErrFilter.getPayloadInput().getEncryptedElement());
        errorInfo = this.m_AvoiDocErrFilter.process();
        if (tempPayElement instanceof EncryptedKeyElement) {
            AvoidedDocErrorFilter tempErrorFilter = null;
            EncryptedDataElement tempPayEncData = null;
            ElementAttackProperties attackPropsPayEncData = null;
            AbstractDetectionInfo tempErrorInfo = null;
            tempErrorFilter = (AvoidedDocErrorFilter)FactoryFilter.createFilter((DetectFilterEnum)DetectFilterEnum.AVOIDDOCFILTER);
            tempPayEncData = HelperFunctions.getEncDataOfEncryptedKey((EncryptedKeyElement)((EncryptedKeyElement)tempPayElement));
            attackPropsPayEncData = tempPayEncData.getAttackProperties();
            tempErrorFilter.setPayloadInput((AbstractEncryptionElement)tempPayEncData);
            tempErrorFilter.setInputDocument(detectReport.getRawFile());
            attackPropsPayEncData.setAttackPayloadElement(tempErrorFilter.getPayloadInput().getEncryptedElement());
            tempErrorInfo = tempErrorFilter.process();
        }
        detectReport.addDetectionInfo(DetectFilterEnum.AVOIDDOCFILTER, errorInfo);
    }

    private void handleEncryptionAttack(DetectionReport detectReport) throws IllegalArgumentException, UnsupportedEncodingException {
        AOracle oracle = null;
        WsdlRequest wsdlRequest = TestSuite.getInstance().getCurrentRequest().getWsdlRequest();
        WebServiceSendCommand serSendCmnd = new WebServiceSendCommand(wsdlRequest);
        oracle = this.initAttackOracle(detectReport, serSendCmnd);
        this.executeAttack(detectReport, oracle);
    }

    private AOracle initAttackOracle(DetectionReport detectReport, WebServiceSendCommand serSendCmnd) throws IllegalArgumentException {
        Object oracle = null;
        Object oracleMode = null;
        if (XMLEncryptionConstants.OracleMode.ERROR_ORACLE == this.m_AttackCfg.getOracleMode()) {
            throw new RuntimeException("Uncompilable source code - Erroneous tree type: uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric");
        }
        throw new IllegalArgumentException("no valid oracle mode");
    }

    private void executeAttack(DetectionReport detectReport, AOracle oracle) throws UnsupportedEncodingException {
        AttackManager attackManager = null;
        byte[] plainText = null;
        String resultString = null;
        try {
            attackManager = new AttackManager(detectReport, this.m_AttackCfg, oracle);
            this.info("Starting " + this.m_AttackCfg.getXMLEncryptionAttack());
            plainText = attackManager.executeAttack();
            resultString = this.m_AttackCfg.getXMLEncryptionAttack().equals((Object)XMLEncryptionConstants.XMLEncryptionAttackMode.PKCS1_ATTACK) ? Utility.bytesToHex((byte[])plainText) : new String(plainText, "UTF-8");
            this.setCurrentPoints(100);
            this.critical("Plaintext of encrypted data: " + resultString + "\nNumber of Oracle Queries: " + attackManager.getOracleofCCAAttacker().getNumberOfQueries());
            this.info("Bytes decrypted: " + plainText.length);
        }
        catch (CryptoAttackException ex) {
            LOG.error((Object)ex);
            this.info("Error: Attack has not successfully executed:\n" + ex.toString());
            this.setCurrentPoints(0);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            this.info("Error: Attack has not successfully executed:\n" + ex.toString());
            this.setCurrentPoints(0);
        }
    }

    public void setUsedSchemaFiles(List<File> fileList) {
        this.log().info((Object)"Cleared all Schemas");
        throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.schemaanalyzer.SchemaAnalyzer");
    }

    public void checkState() {
        this.log().debug((Object)"### CHECK_STATE");
        if (null == this.m_AttackCfg) {
            this.log().debug((Object)"### List Empty -> Not_Configured");
            this.setState(PluginState.Not_Configured);
        } else {
            AbstractEncryptionElement attackPay = this.m_AttackCfg.getChosenAttackPayload();
            if (null != attackPay && null != this.m_OptionManager.getDetectReport().getErrorResponseTab()) {
                if (!this.m_OptionManager.getDetectReport().getErrorResponseTab().getData().isEmpty()) {
                    this.setState(PluginState.Ready);
                } else {
                    this.setState(PluginState.Not_Configured);
                }
            } else {
                this.setState(PluginState.Not_Configured);
            }
        }
    }

    public void stopHook() {
    }

    public void setSchemaAnalyzerDepdingOnOption() {
        if (this.m_OptionManager.getOptionNoSchema().isOn()) {
            throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.schemaanalyzer.SchemaAnalyzer");
        }
        throw new RuntimeException("Uncompilable source code - Erroneous tree type: wsattacker.library.schemaanalyzer.SchemaAnalyzer");
    }

    public AttackConfig getAttackCfg() {
        return this.m_AttackCfg;
    }

    public void setAttackCfg(AttackConfig attackCfg) {
        this.m_AttackCfg = attackCfg;
    }

    static {
        throw new RuntimeException("Uncompilable source code - package wsattacker.library.schemaanalyzer does not exist");
    }
}

