/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlutilities.namespace;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class NamespaceResolver
implements NamespaceContext {
    Map<String, String> prefixUriMap = new HashMap<String, String>();
    Map<String, TreeSet<String>> uriPrefixMap = new HashMap<String, TreeSet<String>>();
    String defaultNamespace = "";

    public NamespaceResolver(Document doc) {
        this.allNamespaces(doc.getDocumentElement());
    }

    private void allNamespaces(Element ele) {
        NamedNodeMap attributes = ele.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (attribute.getPrefix() == null || attribute.getNamespaceURI() == null) continue;
            String prefix = attribute.getPrefix();
            String uri = attribute.getNamespaceURI();
            this.prefixUriMap.put(prefix, uri);
            if (!this.uriPrefixMap.containsKey(uri)) {
                this.uriPrefixMap.put(uri, new TreeSet());
            }
            this.uriPrefixMap.get(uri).add(prefix);
        }
        String prefix = ele.getPrefix();
        String uri = ele.getNamespaceURI();
        if (prefix != null && uri != null) {
            this.prefixUriMap.put(prefix, uri);
            if (!this.uriPrefixMap.containsKey(uri)) {
                this.uriPrefixMap.put(uri, new TreeSet());
            }
            this.uriPrefixMap.get(uri).add(prefix);
        }
        NodeList children = ele.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            this.allNamespaces((Element)children.item(i));
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            return this.defaultNamespace;
        }
        return this.prefixUriMap.get(prefix);
    }

    public void addNamespace(String prefix, String uri) {
        this.prefixUriMap.put(prefix, uri);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.uriPrefixMap.get(namespaceURI).first();
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return this.uriPrefixMap.get(namespaceURI).iterator();
    }

    public Map<String, String> getPrefixUriMap() {
        return this.prefixUriMap;
    }
}

