/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Domain;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.config.DestinationConfig;
import hermes.swing.actions.AddDestinationAction;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class AddDurableTopicAction
extends AddDestinationAction {
    public AddDurableTopicAction() {
        super(Domain.TOPIC);
        this.putValue("Name", "Add durable...");
        this.putValue("ShortDescription", "Add a new durable subscripton.");
        this.putValue("SmallIcon", IconCache.getIcon("jms.durableTopic.new"));
    }

    @Override
    protected void registerTreeSelection() {
        this.enableOnBrowserTreeSelection(new Class[]{HermesTreeNode.class, DestinationConfigTreeNode.class}, this, new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getPath() != null) {
                    if (e.getPath().getLastPathComponent() instanceof DestinationConfigTreeNode) {
                        DestinationConfigTreeNode dNode = (DestinationConfigTreeNode)e.getPath().getLastPathComponent();
                        AddDurableTopicAction.this.setEnabled(dNode.getDomain() == Domain.TOPIC);
                    } else {
                        AddDurableTopicAction.this.setEnabled(e.getPath().getLastPathComponent() instanceof HermesTreeNode);
                    }
                } else {
                    AddDurableTopicAction.this.setEnabled(false);
                }
            }
        }, true);
    }

    @Override
    protected DestinationConfig createDestinationConfig() {
        DestinationConfig selectedConfig;
        DestinationConfig rval = super.createDestinationConfig();
        DestinationConfigTreeNode node = HermesBrowser.getBrowser().getBrowserTree().getFirstSelectedDestinationNode();
        rval.setDomain(Domain.TOPIC.getId());
        rval.setDurable(true);
        if (node != null && (selectedConfig = node.getConfig()).getDomain().intValue() == Domain.TOPIC.getId()) {
            rval.setName(selectedConfig.getName());
        }
        return rval;
    }
}

